/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.SubmoduleSubscription;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.util.RequestId;
import com.google.gerrit.server.util.SubmoduleSectionParser;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitModules {
    private static final Logger log = LoggerFactory.getLogger(GitModules.class);
    private static final String GIT_MODULES = ".gitmodules";
    private final RequestId submissionId;
    Set<SubmoduleSubscription> subscriptions;

    @AssistedInject
    GitModules(@CanonicalWebUrl @Nullable String canonicalWebUrl, @Assisted Branch.NameKey branch, @Assisted MergeOpRepoManager orm) throws IOException {
        this.submissionId = orm.getSubmissionId();
        Project.NameKey project = branch.getParentKey();
        this.logDebug("Loading .gitmodules of {} for project {}", branch, project);
        try {
            BlobBasedConfig bbc;
            MergeOpRepoManager.OpenRepo or = orm.getRepo(project);
            ObjectId id = or.repo.resolve(branch.get());
            if (id == null) {
                throw new IOException("Cannot open branch " + branch.get());
            }
            CodeReviewCommit commit = or.rw.parseCommit(id);
            try (TreeWalk tw = TreeWalk.forPath(or.repo, GIT_MODULES, commit.getTree());){
                if (tw == null || (tw.getRawMode(0) & 0xF000) != 32768) {
                    this.subscriptions = Collections.emptySet();
                    this.logDebug("The .gitmodules file doesn't exist in " + branch, new Object[0]);
                    return;
                }
            }
            try {
                bbc = new BlobBasedConfig(null, or.repo, commit, GIT_MODULES);
            }
            catch (ConfigInvalidException e) {
                throw new IOException("Could not read .gitmodules of super project: " + branch.getParentKey(), e);
            }
            this.subscriptions = new SubmoduleSectionParser(bbc, canonicalWebUrl, branch).parseAllSections();
        }
        catch (NoSuchProjectException e) {
            throw new IOException(e);
        }
    }

    public Collection<SubmoduleSubscription> subscribedTo(Branch.NameKey src) {
        this.logDebug("Checking for a subscription of " + src, new Object[0]);
        ArrayList<SubmoduleSubscription> ret = new ArrayList<SubmoduleSubscription>();
        for (SubmoduleSubscription s : this.subscriptions) {
            if (!s.getSubmodule().equals(src)) continue;
            this.logDebug("Found " + s, new Object[0]);
            ret.add(s);
        }
        return ret;
    }

    private void logDebug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.submissionId + msg, args);
        }
    }

    public static interface Factory {
        public GitModules create(Branch.NameKey var1, MergeOpRepoManager var2);
    }
}

