/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.AutoValue_LabelNormalizer_Result;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Singleton
public class LabelNormalizer {
    private final Provider<ReviewDb> db;
    private final ChangeControl.GenericFactory changeFactory;
    private final IdentifiedUser.GenericFactory userFactory;

    @Inject
    LabelNormalizer(Provider<ReviewDb> db, ChangeControl.GenericFactory changeFactory, IdentifiedUser.GenericFactory userFactory) {
        this.db = db;
        this.changeFactory = changeFactory;
        this.userFactory = userFactory;
    }

    public Result normalize(Change change, Collection<PatchSetApproval> approvals) throws OrmException {
        IdentifiedUser user = this.userFactory.create(change.getOwner());
        return this.normalize(this.changeFactory.controlFor(this.db.get(), change, user), approvals);
    }

    public Result normalize(ChangeControl ctl, Collection<PatchSetApproval> approvals) {
        ArrayList<PatchSetApproval> unchanged = Lists.newArrayListWithCapacity(approvals.size());
        ArrayList<PatchSetApproval> updated = Lists.newArrayListWithCapacity(approvals.size());
        ArrayList<PatchSetApproval> deleted = Lists.newArrayListWithCapacity(approvals.size());
        LabelTypes labelTypes = ctl.getLabelTypes();
        for (PatchSetApproval psa : approvals) {
            Change.Id changeId = psa.getKey().getParentKey().getParentKey();
            Preconditions.checkArgument(changeId.equals(ctl.getId()), "Approval %s does not match change %s", (Object)psa.getKey(), (Object)ctl.getChange().getKey());
            if (psa.isLegacySubmit()) {
                unchanged.add(psa);
                continue;
            }
            LabelType label = labelTypes.byLabel(psa.getLabelId());
            if (label == null) {
                deleted.add(psa);
                continue;
            }
            PatchSetApproval copy = this.copy(psa);
            this.applyTypeFloor(label, copy);
            if (!this.applyRightFloor(ctl, label, copy)) {
                deleted.add(psa);
                continue;
            }
            if (copy.getValue() != psa.getValue()) {
                updated.add(copy);
                continue;
            }
            unchanged.add(psa);
        }
        return Result.create(unchanged, updated, deleted);
    }

    public boolean canVote(ChangeControl ctl, LabelType lt, Account.Id id) {
        return !this.getRange(ctl, lt, id).isEmpty();
    }

    private PatchSetApproval copy(PatchSetApproval src) {
        return new PatchSetApproval(src.getPatchSetId(), src);
    }

    private PermissionRange getRange(ChangeControl ctl, LabelType lt, Account.Id id) {
        String permission = Permission.forLabel(lt.getName());
        IdentifiedUser user = this.userFactory.create(id);
        return ctl.forUser(user).getRange(permission);
    }

    private boolean applyRightFloor(ChangeControl ctl, LabelType lt, PatchSetApproval a) {
        PermissionRange range = this.getRange(ctl, lt, a.getAccountId());
        if (range.isEmpty()) {
            return false;
        }
        a.setValue((short)range.squash(a.getValue()));
        return true;
    }

    private void applyTypeFloor(LabelType lt, PatchSetApproval a) {
        LabelValue atMax;
        LabelValue atMin = lt.getMin();
        if (atMin != null && a.getValue() < atMin.getValue()) {
            a.setValue(atMin.getValue());
        }
        if ((atMax = lt.getMax()) != null && a.getValue() > atMax.getValue()) {
            a.setValue(atMax.getValue());
        }
    }

    @AutoValue
    public static abstract class Result {
        @VisibleForTesting
        static Result create(List<PatchSetApproval> unchanged, List<PatchSetApproval> updated, List<PatchSetApproval> deleted) {
            return new AutoValue_LabelNormalizer_Result(ImmutableList.copyOf(unchanged), ImmutableList.copyOf(updated), ImmutableList.copyOf(deleted));
        }

        public abstract ImmutableList<PatchSetApproval> unchanged();

        public abstract ImmutableList<PatchSetApproval> updated();

        public abstract ImmutableList<PatchSetApproval> deleted();

        public Iterable<PatchSetApproval> getNormalized() {
            return Iterables.concat(this.unchanged(), this.updated());
        }
    }
}

