/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeTip;
import com.google.gerrit.server.git.validators.OnSubmitValidators;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.util.RequestId;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevSort;

public class MergeOpRepoManager
implements AutoCloseable {
    private final Map<Project.NameKey, OpenRepo> openRepos;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final OnSubmitValidators.Factory onSubmitValidatorsFactory;
    private final GitRepositoryManager repoManager;
    private final ProjectCache projectCache;
    private ReviewDb db;
    private Timestamp ts;
    private IdentifiedUser caller;
    private RequestId submissionId;

    @Inject
    MergeOpRepoManager(GitRepositoryManager repoManager, ProjectCache projectCache, BatchUpdate.Factory batchUpdateFactory, OnSubmitValidators.Factory onSubmitValidatorsFactory) {
        this.repoManager = repoManager;
        this.projectCache = projectCache;
        this.batchUpdateFactory = batchUpdateFactory;
        this.onSubmitValidatorsFactory = onSubmitValidatorsFactory;
        this.openRepos = new HashMap<Project.NameKey, OpenRepo>();
    }

    void setContext(ReviewDb db, Timestamp ts, IdentifiedUser caller, RequestId submissionId) {
        this.db = db;
        this.ts = ts;
        this.caller = caller;
        this.submissionId = submissionId;
    }

    public RequestId getSubmissionId() {
        return this.submissionId;
    }

    public OpenRepo getRepo(Project.NameKey project) throws NoSuchProjectException, IOException {
        if (this.openRepos.containsKey(project)) {
            return this.openRepos.get(project);
        }
        ProjectState projectState = this.projectCache.get(project);
        if (projectState == null) {
            throw new NoSuchProjectException(project);
        }
        try {
            OpenRepo or = new OpenRepo(this.repoManager.openRepository(project), projectState);
            this.openRepos.put(project, or);
            return or;
        }
        catch (RepositoryNotFoundException e) {
            throw new NoSuchProjectException(project, (Throwable)e);
        }
    }

    public List<BatchUpdate> batchUpdates(Collection<Project.NameKey> projects) throws NoSuchProjectException, IOException {
        ArrayList<BatchUpdate> updates = new ArrayList<BatchUpdate>(projects.size());
        for (Project.NameKey project : projects) {
            updates.add(this.getRepo(project).getUpdate().setRefLogMessage("merged"));
        }
        return updates;
    }

    @Override
    public void close() {
        for (OpenRepo repo : this.openRepos.values()) {
            repo.close();
        }
        this.openRepos.clear();
    }

    public static class OpenBranch {
        final RefUpdate update;
        final CodeReviewCommit oldTip;
        MergeTip mergeTip;

        OpenBranch(OpenRepo or, Branch.NameKey name) throws IntegrationException {
            block4: {
                try {
                    this.update = or.repo.updateRef(name.get());
                    if (this.update.getOldObjectId() != null) {
                        this.oldTip = or.rw.parseCommit(this.update.getOldObjectId());
                        break block4;
                    }
                    if (Objects.equals(or.repo.getFullBranch(), name.get())) {
                        this.oldTip = null;
                        this.update.setExpectedOldObjectId(ObjectId.zeroId());
                        break block4;
                    }
                    throw new IntegrationException("The destination branch " + name + " does not exist anymore.");
                }
                catch (IOException e) {
                    throw new IntegrationException("Cannot open branch " + name, e);
                }
            }
        }
    }

    public class OpenRepo {
        final Repository repo;
        final CodeReviewCommit.CodeReviewRevWalk rw;
        final RevFlag canMergeFlag;
        final ObjectInserter ins;
        final ProjectState project;
        BatchUpdate update;
        private final ObjectReader reader;
        private final Map<Branch.NameKey, OpenBranch> branches;

        private OpenRepo(Repository repo, ProjectState project) {
            this.repo = repo;
            this.project = project;
            this.ins = repo.newObjectInserter();
            this.reader = this.ins.newReader();
            this.rw = CodeReviewCommit.newRevWalk(this.reader);
            this.rw.sort(RevSort.TOPO);
            this.rw.sort(RevSort.COMMIT_TIME_DESC, true);
            this.rw.setRetainBody(false);
            this.canMergeFlag = this.rw.newFlag("CAN_MERGE");
            this.rw.retainOnReset(this.canMergeFlag);
            this.branches = Maps.newHashMapWithExpectedSize(1);
        }

        OpenBranch getBranch(Branch.NameKey branch) throws IntegrationException {
            OpenBranch ob = this.branches.get(branch);
            if (ob == null) {
                ob = new OpenBranch(this, branch);
                this.branches.put(branch, ob);
            }
            return ob;
        }

        public Repository getRepo() {
            return this.repo;
        }

        Project.NameKey getProjectName() {
            return this.project.getProject().getNameKey();
        }

        public CodeReviewCommit.CodeReviewRevWalk getCodeReviewRevWalk() {
            return this.rw;
        }

        public BatchUpdate getUpdate() {
            Preconditions.checkState(MergeOpRepoManager.this.db != null, "call setContext before getUpdate");
            if (this.update == null) {
                this.update = MergeOpRepoManager.this.batchUpdateFactory.create(MergeOpRepoManager.this.db, this.getProjectName(), MergeOpRepoManager.this.caller, MergeOpRepoManager.this.ts).setRepository(this.repo, this.rw, this.ins).setRequestId(MergeOpRepoManager.this.submissionId).setOnSubmitValidators(MergeOpRepoManager.this.onSubmitValidatorsFactory.create());
            }
            return this.update;
        }

        private void close() {
            if (this.update != null) {
                this.update.close();
            }
            this.rw.close();
            this.reader.close();
            this.ins.close();
            this.repo.close();
        }
    }
}

