/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.strategy.CommitMergeStatus;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebaseSorter {
    private static final Logger log = LoggerFactory.getLogger(RebaseSorter.class);
    private final CodeReviewCommit.CodeReviewRevWalk rw;
    private final RevFlag canMergeFlag;
    private final RevCommit initialTip;
    private final Set<RevCommit> alreadyAccepted;
    private final InternalChangeQuery internalChangeQuery;

    public RebaseSorter(CodeReviewCommit.CodeReviewRevWalk rw, RevCommit initialTip, Set<RevCommit> alreadyAccepted, RevFlag canMergeFlag, InternalChangeQuery internalChangeQuery) {
        this.rw = rw;
        this.canMergeFlag = canMergeFlag;
        this.initialTip = initialTip;
        this.alreadyAccepted = alreadyAccepted;
        this.internalChangeQuery = internalChangeQuery;
    }

    public List<CodeReviewCommit> sort(Collection<CodeReviewCommit> incoming) throws IOException {
        ArrayList<CodeReviewCommit> sorted = new ArrayList<CodeReviewCommit>();
        HashSet<CodeReviewCommit> sort = new HashSet<CodeReviewCommit>(incoming);
        while (!sort.isEmpty()) {
            CodeReviewCommit c;
            CodeReviewCommit n = RebaseSorter.removeOne(sort);
            this.rw.resetRetain(this.canMergeFlag);
            this.rw.markStart(n);
            if (this.initialTip != null) {
                this.rw.markUninteresting(this.initialTip);
            }
            ArrayList<CodeReviewCommit> contents = new ArrayList<CodeReviewCommit>();
            while ((c = this.rw.next()) != null) {
                if (!c.has(this.canMergeFlag) || !incoming.contains(c)) {
                    if (this.isAlreadyMerged(c, n.change().getDest())) {
                        this.rw.markUninteresting(c);
                        break;
                    }
                    n.setStatusCode(CommitMergeStatus.MISSING_DEPENDENCY);
                    break;
                }
                contents.add(c);
            }
            if (n.getStatusCode() == CommitMergeStatus.MISSING_DEPENDENCY) continue;
            sort.removeAll(contents);
            Collections.reverse(contents);
            sorted.removeAll(contents);
            sorted.addAll(contents);
        }
        return sorted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAlreadyMerged(CodeReviewCommit commit, Branch.NameKey dest) throws IOException {
        try (CodeReviewCommit.CodeReviewRevWalk mirw = CodeReviewCommit.newRevWalk(this.rw.getObjectReader());){
            mirw.reset();
            mirw.markStart(commit);
            for (RevCommit accepted : this.alreadyAccepted) {
                if (!mirw.isMergedInto(mirw.parseCommit(commit), mirw.parseCommit(accepted))) continue;
                log.debug("Dependency {} merged into branch head {}.", (Object)commit.getName(), (Object)accepted.getName());
                boolean bl = true;
                return bl;
            }
            List<ChangeData> changes = this.internalChangeQuery.byCommit(commit);
            for (ChangeData change : changes) {
                if (change.change().getStatus() != Change.Status.MERGED || !change.change().getDest().equals(dest)) continue;
                log.debug("Dependency {} associated with merged change {}.", (Object)commit.getName(), (Object)change.getId());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (OrmException e) {
            throw new IOException(e);
        }
    }

    private static <T> T removeOne(Collection<T> c) {
        Iterator<T> i = c.iterator();
        T r = i.next();
        i.remove();
        return r;
    }
}

