/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.collect.FluentIterable;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeSorter;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.strategy.CherryPick;
import com.google.gerrit.server.git.strategy.FastForwardOnly;
import com.google.gerrit.server.git.strategy.MergeAlways;
import com.google.gerrit.server.git.strategy.MergeIfNecessary;
import com.google.gerrit.server.git.strategy.RebaseAlways;
import com.google.gerrit.server.git.strategy.RebaseIfNecessary;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmitDryRun {
    private static final Logger log = LoggerFactory.getLogger(SubmitDryRun.class);
    private final ProjectCache projectCache;
    private final MergeUtil.Factory mergeUtilFactory;

    public static Iterable<ObjectId> getAlreadyAccepted(Repository repo) throws IOException {
        return FluentIterable.from(repo.getRefDatabase().getRefs("refs/heads/").values()).append((Iterable<Ref>)repo.getRefDatabase().getRefs("refs/tags/").values()).transform(Ref::getObjectId);
    }

    public static Set<RevCommit> getAlreadyAccepted(Repository repo, RevWalk rw) throws IOException {
        HashSet<RevCommit> accepted = new HashSet<RevCommit>();
        SubmitDryRun.addCommits(SubmitDryRun.getAlreadyAccepted(repo), rw, accepted);
        return accepted;
    }

    public static void addCommits(Iterable<ObjectId> ids, RevWalk rw, Collection<RevCommit> out) throws IOException {
        for (ObjectId id : ids) {
            RevObject obj = rw.parseAny(id);
            if (!(obj instanceof RevCommit)) continue;
            out.add((RevCommit)obj);
        }
    }

    @Inject
    SubmitDryRun(ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory) {
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
    }

    public boolean run(SubmitType submitType, Repository repo, CodeReviewCommit.CodeReviewRevWalk rw, Branch.NameKey destBranch, ObjectId tip, ObjectId toMerge, Set<RevCommit> alreadyAccepted) throws IntegrationException, NoSuchProjectException, IOException {
        CodeReviewCommit tipCommit = rw.parseCommit(tip);
        CodeReviewCommit toMergeCommit = rw.parseCommit(toMerge);
        RevFlag canMerge = rw.newFlag("CAN_MERGE");
        toMergeCommit.add(canMerge);
        Arguments args = new Arguments(repo, rw, this.mergeUtilFactory.create(this.getProject(destBranch)), new MergeSorter(rw, alreadyAccepted, canMerge));
        switch (submitType) {
            case CHERRY_PICK: {
                return CherryPick.dryRun(args, tipCommit, toMergeCommit);
            }
            case FAST_FORWARD_ONLY: {
                return FastForwardOnly.dryRun(args, tipCommit, toMergeCommit);
            }
            case MERGE_ALWAYS: {
                return MergeAlways.dryRun(args, tipCommit, toMergeCommit);
            }
            case MERGE_IF_NECESSARY: {
                return MergeIfNecessary.dryRun(args, tipCommit, toMergeCommit);
            }
            case REBASE_IF_NECESSARY: {
                return RebaseIfNecessary.dryRun(args, tipCommit, toMergeCommit);
            }
            case REBASE_ALWAYS: {
                return RebaseAlways.dryRun(args, tipCommit, toMergeCommit);
            }
        }
        String errorMsg = "No submit strategy for: " + (Object)((Object)submitType);
        log.error(errorMsg);
        throw new IntegrationException(errorMsg);
    }

    private ProjectState getProject(Branch.NameKey branch) throws NoSuchProjectException {
        ProjectState p = this.projectCache.get(branch.getParentKey());
        if (p == null) {
            throw new NoSuchProjectException(branch.getParentKey());
        }
        return p;
    }

    static class Arguments {
        final Repository repo;
        final CodeReviewCommit.CodeReviewRevWalk rw;
        final MergeUtil mergeUtil;
        final MergeSorter mergeSorter;

        Arguments(Repository repo, CodeReviewCommit.CodeReviewRevWalk rw, MergeUtil mergeUtil, MergeSorter mergeSorter) {
            this.repo = repo;
            this.rw = rw;
            this.mergeUtil = mergeUtil;
            this.mergeSorter = mergeSorter;
        }
    }
}

