/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.group.GetIncludedGroup;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.IncludedGroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Singleton
public class AddIncludedGroups
implements RestModifyView<GroupResource, Input> {
    private final GroupsCollection groupsCollection;
    private final GroupIncludeCache groupIncludeCache;
    private final Provider<ReviewDb> db;
    private final GroupJson json;
    private final AuditService auditService;

    @Inject
    public AddIncludedGroups(GroupsCollection groupsCollection, GroupIncludeCache groupIncludeCache, Provider<ReviewDb> db, GroupJson json, AuditService auditService) {
        this.groupsCollection = groupsCollection;
        this.groupIncludeCache = groupIncludeCache;
        this.db = db;
        this.json = json;
        this.auditService = auditService;
    }

    public List<GroupInfo> apply(GroupResource resource, Input input) throws MethodNotAllowedException, AuthException, UnprocessableEntityException, OrmException {
        AccountGroup group = resource.toAccountGroup();
        if (group == null) {
            throw new MethodNotAllowedException();
        }
        input = Input.init(input);
        GroupControl control = resource.getControl();
        HashMap<AccountGroup.UUID, AccountGroupById> newIncludedGroups = new HashMap<AccountGroup.UUID, AccountGroupById>();
        ArrayList<GroupInfo> result = new ArrayList<GroupInfo>();
        Account.Id me = control.getUser().getAccountId();
        for (String includedGroup : input.groups) {
            GroupDescription.Basic d = this.groupsCollection.parse(includedGroup);
            if (!control.canAddGroup()) {
                throw new AuthException(String.format("Cannot add group: %s", d.getName()));
            }
            if (!newIncludedGroups.containsKey(d.getGroupUUID())) {
                AccountGroupById.Key agiKey = new AccountGroupById.Key(group.getId(), d.getGroupUUID());
                AccountGroupById agi = this.db.get().accountGroupById().get(agiKey);
                if (agi == null) {
                    agi = new AccountGroupById(agiKey);
                    newIncludedGroups.put(d.getGroupUUID(), agi);
                }
            }
            result.add(this.json.format(d));
        }
        if (!newIncludedGroups.isEmpty()) {
            this.auditService.dispatchAddGroupsToGroup(me, newIncludedGroups.values());
            this.db.get().accountGroupById().insert(newIncludedGroups.values());
            for (AccountGroupById agi : newIncludedGroups.values()) {
                this.groupIncludeCache.evictParentGroupsOf(agi.getIncludeUUID());
            }
            this.groupIncludeCache.evictSubgroupsOf(group.getGroupUUID());
        }
        return result;
    }

    @Singleton
    static class UpdateIncludedGroup
    implements RestModifyView<IncludedGroupResource, PutIncludedGroup.Input> {
        private final Provider<GetIncludedGroup> get;

        @Inject
        UpdateIncludedGroup(Provider<GetIncludedGroup> get) {
            this.get = get;
        }

        public GroupInfo apply(IncludedGroupResource resource, PutIncludedGroup.Input input) throws OrmException {
            return this.get.get().apply(resource);
        }
    }

    static class PutIncludedGroup
    implements RestModifyView<GroupResource, Input> {
        private final AddIncludedGroups put;
        private final String id;

        PutIncludedGroup(AddIncludedGroups put, String id) {
            this.put = put;
            this.id = id;
        }

        public GroupInfo apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, ResourceNotFoundException, OrmException {
            com.google.gerrit.server.group.AddIncludedGroups$Input in = new com.google.gerrit.server.group.AddIncludedGroups$Input();
            in.groups = ImmutableList.of(this.id);
            try {
                List<GroupInfo> list = this.put.apply(resource, in);
                if (list.size() == 1) {
                    return list.get(0);
                }
                throw new IllegalStateException();
            }
            catch (UnprocessableEntityException e) {
                throw new ResourceNotFoundException(this.id);
            }
        }

        static class Input {
            Input() {
            }
        }
    }

    public static class Input {
        @DefaultInput
        String _oneGroup;
        public List<String> groups;

        public static Input fromGroups(List<String> groups) {
            Input in = new Input();
            in.groups = groups;
            return in;
        }

        static Input init(Input in) {
            if (in == null) {
                in = new Input();
            }
            if (in.groups == null) {
                in.groups = Lists.newArrayListWithCapacity(1);
            }
            if (!Strings.isNullOrEmpty(in._oneGroup)) {
                in.groups.add(in._oneGroup);
            }
            return in;
        }
    }
}

