/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.client.ListGroupsOption;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetGroups;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupComparator;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kohsuke.args4j.Option;

public class ListGroups
implements RestReadView<TopLevelResource> {
    protected final GroupCache groupCache;
    private final List<ProjectControl> projects = new ArrayList<ProjectControl>();
    private final Set<AccountGroup.UUID> groupsToInspect = new HashSet<AccountGroup.UUID>();
    private final GroupControl.Factory groupControlFactory;
    private final GroupControl.GenericFactory genericGroupControlFactory;
    private final Provider<IdentifiedUser> identifiedUser;
    private final IdentifiedUser.GenericFactory userFactory;
    private final GetGroups accountGetGroups;
    private final GroupJson json;
    private final GroupBackend groupBackend;
    private EnumSet<ListGroupsOption> options = EnumSet.noneOf(ListGroupsOption.class);
    private boolean visibleToAll;
    private Account.Id user;
    private boolean owned;
    private int limit;
    private int start;
    private String matchSubstring;
    private String suggest;

    @Option(name="--project", aliases={"-p"}, usage="projects for which the groups should be listed")
    public void addProject(ProjectControl project) {
        this.projects.add(project);
    }

    @Option(name="--visible-to-all", usage="to list only groups that are visible to all registered users")
    public void setVisibleToAll(boolean visibleToAll) {
        this.visibleToAll = visibleToAll;
    }

    @Option(name="--user", aliases={"-u"}, usage="user for which the groups should be listed")
    public void setUser(Account.Id user) {
        this.user = user;
    }

    @Option(name="--owned", usage="to list only groups that are owned by the specified user or by the calling user if no user was specifed")
    public void setOwned(boolean owned) {
        this.owned = owned;
    }

    @Deprecated
    @Option(name="--query", aliases={"-q"}, usage="group to inspect (deprecated: use --group/-g instead)")
    void addGroup_Deprecated(AccountGroup.UUID uuid) {
        this.addGroup(uuid);
    }

    @Option(name="--group", aliases={"-g"}, usage="group to inspect")
    public void addGroup(AccountGroup.UUID uuid) {
        this.groupsToInspect.add(uuid);
    }

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of groups to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="number of groups to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="--match", aliases={"-m"}, metaVar="MATCH", usage="match group substring")
    public void setMatchSubstring(String matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    @Option(name="--suggest", aliases={"-s"}, usage="to get a suggestion of groups")
    public void setSuggest(String suggest) {
        this.suggest = suggest;
    }

    @Option(name="-o", usage="Output options per group")
    void addOption(ListGroupsOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.options.addAll(ListGroupsOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Inject
    protected ListGroups(GroupCache groupCache, GroupControl.Factory groupControlFactory, GroupControl.GenericFactory genericGroupControlFactory, Provider<IdentifiedUser> identifiedUser, IdentifiedUser.GenericFactory userFactory, GetGroups accountGetGroups, GroupJson json, GroupBackend groupBackend) {
        this.groupCache = groupCache;
        this.groupControlFactory = groupControlFactory;
        this.genericGroupControlFactory = genericGroupControlFactory;
        this.identifiedUser = identifiedUser;
        this.userFactory = userFactory;
        this.accountGetGroups = accountGetGroups;
        this.json = json;
        this.groupBackend = groupBackend;
    }

    public void setOptions(EnumSet<ListGroupsOption> options) {
        this.options = options;
    }

    public Account.Id getUser() {
        return this.user;
    }

    public List<ProjectControl> getProjects() {
        return this.projects;
    }

    public SortedMap<String, GroupInfo> apply(TopLevelResource resource) throws OrmException, BadRequestException {
        TreeMap<String, GroupInfo> output = new TreeMap<String, GroupInfo>();
        for (GroupInfo info : this.get()) {
            output.put(MoreObjects.firstNonNull(info.name, "Group " + Url.decode(info.id)), info);
            info.name = null;
        }
        return output;
    }

    public List<GroupInfo> get() throws OrmException, BadRequestException {
        if (!Strings.isNullOrEmpty(this.suggest)) {
            return this.suggestGroups();
        }
        if (this.owned) {
            return this.getGroupsOwnedBy(this.user != null ? this.userFactory.create(this.user) : this.identifiedUser.get());
        }
        if (this.user != null) {
            return this.accountGetGroups.apply(new AccountResource(this.userFactory.create(this.user)));
        }
        return this.getAllGroups();
    }

    private List<GroupInfo> getAllGroups() throws OrmException {
        List<AccountGroup> groupList;
        if (!this.projects.isEmpty()) {
            HashMap<AccountGroup.UUID, AccountGroup> groups = new HashMap<AccountGroup.UUID, AccountGroup>();
            for (ProjectControl projectControl : this.projects) {
                Set<GroupReference> groupsRefs = projectControl.getAllGroups();
                for (GroupReference groupRef : groupsRefs) {
                    AccountGroup group = this.groupCache.get(groupRef.getUUID());
                    if (group == null) continue;
                    groups.put(group.getGroupUUID(), group);
                }
            }
            groupList = this.filterGroups(groups.values());
        } else {
            groupList = this.filterGroups(this.groupCache.all());
        }
        ArrayList<GroupInfo> groupInfos = Lists.newArrayListWithCapacity(groupList.size());
        int found = 0;
        int foundIndex = 0;
        for (AccountGroup group : groupList) {
            if (foundIndex++ < this.start) continue;
            if (this.limit > 0 && ++found > this.limit) break;
            groupInfos.add(this.json.addOptions(this.options).format(GroupDescriptions.forAccountGroup(group)));
        }
        return groupInfos;
    }

    private List<GroupInfo> suggestGroups() throws OrmException, BadRequestException {
        if (this.conflictingSuggestParameters()) {
            throw new BadRequestException("You should only have no more than one --project and -n with --suggest");
        }
        ArrayList<GroupReference> groupRefs = Lists.newArrayList(Iterables.limit(this.groupBackend.suggest(this.suggest, Iterables.getFirst(this.projects, null)), this.limit <= 0 ? 10 : Math.min(this.limit, 10)));
        ArrayList<GroupInfo> groupInfos = Lists.newArrayListWithCapacity(groupRefs.size());
        for (GroupReference ref : groupRefs) {
            GroupDescription.Basic desc = this.groupBackend.get(ref.getUUID());
            if (desc == null) continue;
            groupInfos.add(this.json.addOptions(this.options).format(desc));
        }
        return groupInfos;
    }

    private boolean conflictingSuggestParameters() {
        if (Strings.isNullOrEmpty(this.suggest)) {
            return false;
        }
        if (this.projects.size() > 1) {
            return true;
        }
        if (this.visibleToAll) {
            return true;
        }
        if (this.user != null) {
            return true;
        }
        if (this.owned) {
            return true;
        }
        if (this.start != 0) {
            return true;
        }
        if (!this.groupsToInspect.isEmpty()) {
            return true;
        }
        return !Strings.isNullOrEmpty(this.matchSubstring);
    }

    private List<GroupInfo> getGroupsOwnedBy(IdentifiedUser user) throws OrmException {
        ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
        int found = 0;
        int foundIndex = 0;
        for (AccountGroup g : this.filterGroups(this.groupCache.all())) {
            GroupControl ctl = this.groupControlFactory.controlFor(g);
            try {
                if (!this.genericGroupControlFactory.controlFor(user, g.getGroupUUID()).isOwner() || foundIndex++ < this.start) continue;
                if (this.limit > 0 && ++found > this.limit) break;
                groups.add(this.json.addOptions(this.options).format(ctl.getGroup()));
            }
            catch (NoSuchGroupException e) {}
        }
        return groups;
    }

    private List<AccountGroup> filterGroups(Collection<AccountGroup> groups) {
        ArrayList<AccountGroup> filteredGroups = new ArrayList<AccountGroup>(groups.size());
        boolean isAdmin = this.identifiedUser.get().getCapabilities().canAdministrateServer();
        for (AccountGroup group : groups) {
            GroupControl c;
            if (!Strings.isNullOrEmpty(this.matchSubstring) && !group.getName().toLowerCase(Locale.US).contains(this.matchSubstring.toLowerCase(Locale.US)) || this.visibleToAll && !group.isVisibleToAll() || !this.groupsToInspect.isEmpty() && !this.groupsToInspect.contains(group.getGroupUUID()) || !isAdmin && !(c = this.groupControlFactory.controlFor(group)).isVisible()) continue;
            filteredGroups.add(group);
        }
        Collections.sort(filteredGroups, new GroupComparator());
        return filteredGroups;
    }
}

