/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.StartupCheck;
import com.google.gerrit.server.StartupException;
import com.google.gerrit.server.account.AbstractGroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.ListGroupMembership;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Config;

@Singleton
public class SystemGroupBackend
extends AbstractGroupBackend {
    public static final String SYSTEM_GROUP_SCHEME = "global:";
    public static final AccountGroup.UUID ANONYMOUS_USERS = new AccountGroup.UUID("global:Anonymous-Users");
    public static final AccountGroup.UUID REGISTERED_USERS = new AccountGroup.UUID("global:Registered-Users");
    public static final AccountGroup.UUID PROJECT_OWNERS = new AccountGroup.UUID("global:Project-Owners");
    public static final AccountGroup.UUID CHANGE_OWNER = new AccountGroup.UUID("global:Change-Owner");
    private static final AccountGroup.UUID[] all = new AccountGroup.UUID[]{ANONYMOUS_USERS, REGISTERED_USERS, PROJECT_OWNERS, CHANGE_OWNER};
    private final ImmutableSet<String> reservedNames;
    private final SortedMap<String, GroupReference> names;
    private final ImmutableMap<AccountGroup.UUID, GroupReference> uuids;

    public static boolean isSystemGroup(AccountGroup.UUID uuid) {
        return uuid.get().startsWith(SYSTEM_GROUP_SCHEME);
    }

    public static boolean isAnonymousOrRegistered(GroupReference ref) {
        return SystemGroupBackend.isAnonymousOrRegistered(ref.getUUID());
    }

    public static boolean isAnonymousOrRegistered(AccountGroup.UUID uuid) {
        return ANONYMOUS_USERS.equals(uuid) || REGISTERED_USERS.equals(uuid);
    }

    @Inject
    @VisibleForTesting
    public SystemGroupBackend(@GerritServerConfig Config cfg) {
        TreeMap<String, GroupReference> n = new TreeMap<String, GroupReference>();
        ImmutableMap.Builder<AccountGroup.UUID, GroupReference> u = ImmutableMap.builder();
        ImmutableSet.Builder reservedNamesBuilder = ImmutableSet.builder();
        for (AccountGroup.UUID uuid : all) {
            int c = uuid.get().indexOf(58);
            String defaultName = uuid.get().substring(c + 1).replace('-', ' ');
            reservedNamesBuilder.add(defaultName);
            String configuredName = cfg.getString("groups", uuid.get(), "name");
            GroupReference ref = new GroupReference(uuid, MoreObjects.firstNonNull(configuredName, defaultName));
            n.put(ref.getName().toLowerCase(Locale.US), ref);
            u.put(ref.getUUID(), ref);
        }
        this.reservedNames = reservedNamesBuilder.build();
        this.names = Collections.unmodifiableSortedMap(n);
        this.uuids = u.build();
    }

    public GroupReference getGroup(AccountGroup.UUID uuid) {
        return Preconditions.checkNotNull(this.uuids.get(uuid), "group %s not found", (Object)uuid.get());
    }

    public Set<String> getNames() {
        return this.names.values().stream().map(r -> r.getName()).collect(Collectors.toSet());
    }

    public Set<String> getReservedNames() {
        return this.reservedNames;
    }

    @Override
    public boolean handles(AccountGroup.UUID uuid) {
        return SystemGroupBackend.isSystemGroup(uuid);
    }

    @Override
    public GroupDescription.Basic get(AccountGroup.UUID uuid) {
        final GroupReference ref = this.uuids.get(uuid);
        if (ref == null) {
            return null;
        }
        return new GroupDescription.Basic(){

            @Override
            public String getName() {
                return ref.getName();
            }

            @Override
            public AccountGroup.UUID getGroupUUID() {
                return ref.getUUID();
            }

            @Override
            public String getUrl() {
                return null;
            }

            @Override
            public String getEmailAddress() {
                return null;
            }
        };
    }

    @Override
    public Collection<GroupReference> suggest(String name, ProjectControl project) {
        String nameLC = name.toLowerCase(Locale.US);
        SortedMap<String, GroupReference> matches = this.names.tailMap(nameLC);
        if (matches.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GroupReference> r = new ArrayList<GroupReference>(matches.size());
        for (Map.Entry<String, GroupReference> e : matches.entrySet()) {
            if (!e.getKey().startsWith(nameLC)) break;
            r.add(e.getValue());
        }
        return r;
    }

    @Override
    public GroupMembership membershipsOf(IdentifiedUser user) {
        return new ListGroupMembership(ImmutableSet.of(ANONYMOUS_USERS, REGISTERED_USERS));
    }

    public static class NameCheck
    implements StartupCheck {
        private final Config cfg;
        private final GroupCache groupCache;

        @Inject
        NameCheck(@GerritServerConfig Config cfg, GroupCache groupCache) {
            this.cfg = cfg;
            this.groupCache = groupCache;
        }

        @Override
        public void check() throws StartupException {
            HashMap<AccountGroup.UUID, String> configuredNames = new HashMap<AccountGroup.UUID, String>();
            HashMap<String, AccountGroup.UUID> byLowerCaseConfiguredName = new HashMap<String, AccountGroup.UUID>();
            for (AccountGroup.UUID uuid : all) {
                String configuredName = this.cfg.getString("groups", uuid.get(), "name");
                if (configuredName == null) continue;
                configuredNames.put(uuid, configuredName);
                byLowerCaseConfiguredName.put(configuredName.toLowerCase(Locale.US), uuid);
            }
            if (configuredNames.isEmpty()) {
                return;
            }
            for (AccountGroup g : this.groupCache.all()) {
                String name = g.getName().toLowerCase(Locale.US);
                if (!byLowerCaseConfiguredName.keySet().contains(name)) continue;
                AccountGroup.UUID uuidSystemGroup = (AccountGroup.UUID)byLowerCaseConfiguredName.get(name);
                throw new StartupException(String.format("The configured name '%s' for system group '%s' is ambiguous with the name '%s' of existing group '%s'. Please remove/change the value for groups.%s.name in gerrit.config.", configuredNames.get(uuidSystemGroup), uuidSystemGroup.get(), g.getName(), g.getGroupUUID().get(), uuidSystemGroup.get()));
            }
        }
    }
}

