/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.index.FieldType;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import org.eclipse.jgit.lib.Config;

public final class FieldDef<I, T> {
    private final String name;
    private final FieldType<?> type;
    private final boolean stored;
    private final boolean repeatable;
    private final GetterWithArgs<I, T> getter;

    public static Builder<String> exact(String name) {
        return new Builder<String>(FieldType.EXACT, name);
    }

    public static Builder<String> fullText(String name) {
        return new Builder<String>(FieldType.FULL_TEXT, name);
    }

    public static Builder<Integer> intRange(String name) {
        return new Builder<Integer>(FieldType.INTEGER_RANGE, name).stored();
    }

    public static Builder<Integer> integer(String name) {
        return new Builder<Integer>(FieldType.INTEGER, name);
    }

    public static Builder<String> prefix(String name) {
        return new Builder<String>(FieldType.PREFIX, name);
    }

    public static Builder<byte[]> storedOnly(String name) {
        return new Builder<byte[]>(FieldType.STORED_ONLY, name).stored();
    }

    public static Builder<Timestamp> timestamp(String name) {
        return new Builder<Timestamp>(FieldType.TIMESTAMP, name);
    }

    private FieldDef(String name, FieldType<?> type, boolean stored, boolean repeatable, GetterWithArgs<I, T> getter) {
        Preconditions.checkArgument(!repeatable || type != FieldType.INTEGER_RANGE, "Range queries against repeated fields are unsupported");
        this.name = FieldDef.checkName(name);
        this.type = Preconditions.checkNotNull(type);
        this.stored = stored;
        this.repeatable = repeatable;
        this.getter = Preconditions.checkNotNull(getter);
    }

    private static String checkName(String name) {
        CharMatcher m = CharMatcher.anyOf("abcdefghijklmnopqrstuvwxyz0123456789_");
        Preconditions.checkArgument(name != null && m.matchesAllOf(name), "illegal field name: %s", (Object)name);
        return name;
    }

    public String getName() {
        return this.name;
    }

    public FieldType<?> getType() {
        return this.type;
    }

    public boolean isStored() {
        return this.stored;
    }

    public T get(I input, FillArgs args) throws OrmException {
        try {
            return this.getter.get(input, args);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public static class Builder<T> {
        private final FieldType<T> type;
        private final String name;
        private boolean stored;

        public Builder(FieldType<T> type, String name) {
            this.type = Preconditions.checkNotNull(type);
            this.name = Preconditions.checkNotNull(name);
        }

        public Builder<T> stored() {
            this.stored = true;
            return this;
        }

        public <I> FieldDef<I, T> build(Getter<I, T> getter) {
            return this.build((I in, FillArgs a) -> getter.get(in));
        }

        public <I> FieldDef<I, T> build(GetterWithArgs<I, T> getter) {
            return new FieldDef(this.name, this.type, this.stored, false, getter);
        }

        public <I> FieldDef<I, Iterable<T>> buildRepeatable(Getter<I, Iterable<T>> getter) {
            return this.buildRepeatable((I in, FillArgs a) -> (Iterable)getter.get(in));
        }

        public <I> FieldDef<I, Iterable<T>> buildRepeatable(GetterWithArgs<I, Iterable<T>> getter) {
            return new FieldDef(this.name, this.type, this.stored, true, getter);
        }
    }

    public static class FillArgs {
        public final TrackingFooters trackingFooters;
        public final boolean allowsDrafts;
        public final AllUsersName allUsers;

        @Inject
        FillArgs(TrackingFooters trackingFooters, @GerritServerConfig Config cfg, AllUsersName allUsers) {
            this.trackingFooters = trackingFooters;
            this.allowsDrafts = cfg == null ? true : cfg.getBoolean("change", "allowDrafts", true);
            this.allUsers = allUsers;
        }
    }

    @FunctionalInterface
    public static interface GetterWithArgs<I, T> {
        public T get(I var1, FillArgs var2) throws OrmException, IOException;
    }

    @FunctionalInterface
    public static interface Getter<I, T> {
        public T get(I var1) throws OrmException, IOException;
    }
}

