/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.ReplyToChangeSender;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeleteReviewerSender
extends ReplyToChangeSender {
    private final Set<Account.Id> reviewers = new HashSet<Account.Id>();

    @Inject
    public DeleteReviewerSender(EmailArguments ea, @Assisted Project.NameKey project, @Assisted Change.Id id) throws OrmException {
        super(ea, "deleteReviewer", DeleteReviewerSender.newChangeData(ea, project, id));
    }

    public void addReviewers(Collection<Account.Id> cc) {
        this.reviewers.addAll(cc);
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.ccAllApprovals();
        this.bccStarredBy();
        this.ccExistingReviewers();
        this.includeWatchers(WatchConfig.NotifyType.ALL_COMMENTS);
        this.add(RecipientType.TO, this.reviewers);
        this.removeUsersThatIgnoredTheChange();
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.textTemplate("DeleteReviewer"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("DeleteReviewerHtml"));
        }
    }

    public List<String> getReviewerNames() {
        if (this.reviewers.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Account.Id id : this.reviewers) {
            names.add(this.getNameFor(id));
        }
        return names;
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("reviewerNames", this.getReviewerNames());
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory
    extends ReplyToChangeSender.Factory<DeleteReviewerSender> {
        @Override
        public DeleteReviewerSender create(Project.NameKey var1, Change.Id var2);
    }
}

