/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.ReplyToChangeSender;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class MergedSender
extends ReplyToChangeSender {
    private final LabelTypes labelTypes;

    @Inject
    public MergedSender(EmailArguments ea, @Assisted Project.NameKey project, @Assisted Change.Id id) throws OrmException {
        super(ea, "merged", MergedSender.newChangeData(ea, project, id));
        this.labelTypes = this.changeData.changeControl().getLabelTypes();
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.ccAllApprovals();
        this.bccStarredBy();
        this.includeWatchers(WatchConfig.NotifyType.ALL_COMMENTS);
        this.includeWatchers(WatchConfig.NotifyType.SUBMITTED_CHANGES);
        this.removeUsersThatIgnoredTheChange();
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.textTemplate("Merged"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("MergedHtml"));
        }
    }

    public String getApprovals() {
        try {
            HashBasedTable<Account.Id, String, PatchSetApproval> pos = HashBasedTable.create();
            HashBasedTable<Account.Id, String, PatchSetApproval> neg = HashBasedTable.create();
            for (PatchSetApproval ca : this.args.approvalsUtil.byPatchSet(this.args.db.get(), this.changeData.changeControl(), this.patchSet.getId())) {
                LabelType lt = this.labelTypes.byLabel(ca.getLabelId());
                if (lt == null) continue;
                if (ca.getValue() > 0) {
                    pos.put(ca.getAccountId(), lt.getName(), ca);
                    continue;
                }
                if (ca.getValue() >= 0) continue;
                neg.put(ca.getAccountId(), lt.getName(), ca);
            }
            return this.format("Approvals", pos) + this.format("Objections", neg);
        }
        catch (OrmException ormException) {
            return "";
        }
    }

    private String format(String type, Table<Account.Id, String, PatchSetApproval> approvals) {
        StringBuilder txt = new StringBuilder();
        if (approvals.isEmpty()) {
            return "";
        }
        txt.append(type).append(":\n");
        for (Account.Id id : approvals.rowKeySet()) {
            txt.append("  ");
            txt.append(this.getNameFor(id));
            txt.append(": ");
            boolean first = true;
            for (LabelType lt : this.labelTypes.getLabelTypes()) {
                PatchSetApproval ca = approvals.get(id, lt.getName());
                if (ca == null) continue;
                if (first) {
                    first = false;
                } else {
                    txt.append("; ");
                }
                LabelValue v = lt.getValue(ca);
                if (v != null) {
                    txt.append(v.getText());
                    continue;
                }
                txt.append(lt.getName());
                txt.append('=');
                txt.append(LabelValue.formatValue(ca.getValue()));
            }
            txt.append('\n');
        }
        txt.append('\n');
        return txt.toString();
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("approvals", this.getApprovals());
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory {
        public MergedSender create(Project.NameKey var1, Change.Id var2);
    }
}

