/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbTable;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jgit.lib.Config;

@Singleton
public class ConfigNotesMigration
extends NotesMigration {
    private static final String NOTE_DB = "noteDb";
    private static final String DISABLE_REVIEW_DB = "disableReviewDb";
    private static final String PRIMARY_STORAGE = "primaryStorage";
    private static final String READ = "read";
    private static final String SEQUENCE = "sequence";
    private static final String WRITE = "write";
    private final boolean writeChanges;
    private final boolean readChanges;
    private final boolean readChangeSequence;
    private final NoteDbChangeState.PrimaryStorage changePrimaryStorage;
    private final boolean disableChangeReviewDb;

    private static void checkConfig(Config cfg) {
        ImmutableSet<String> keys = ImmutableSet.of(NoteDbTable.CHANGES.key());
        ImmutableSet<String> allowed = ImmutableSet.of(DISABLE_REVIEW_DB.toLowerCase(), PRIMARY_STORAGE.toLowerCase(), READ.toLowerCase(), WRITE.toLowerCase(), SEQUENCE.toLowerCase());
        for (String t : cfg.getSubsections(NOTE_DB)) {
            Preconditions.checkArgument(keys.contains(t.toLowerCase()), "invalid NoteDb table: %s", (Object)t);
            for (String key : cfg.getNames(NOTE_DB, t)) {
                Preconditions.checkArgument(allowed.contains(key.toLowerCase()), "invalid NoteDb key: %s.%s", (Object)t, (Object)key);
            }
        }
    }

    public static Config allEnabledConfig() {
        Config cfg = new Config();
        cfg.setBoolean(NOTE_DB, NoteDbTable.CHANGES.key(), WRITE, true);
        cfg.setBoolean(NOTE_DB, NoteDbTable.CHANGES.key(), READ, true);
        return cfg;
    }

    @Inject
    ConfigNotesMigration(@GerritServerConfig Config cfg) {
        ConfigNotesMigration.checkConfig(cfg);
        this.writeChanges = cfg.getBoolean(NOTE_DB, NoteDbTable.CHANGES.key(), WRITE, false);
        this.readChanges = cfg.getBoolean(NOTE_DB, NoteDbTable.CHANGES.key(), READ, false);
        this.readChangeSequence = cfg.getBoolean(NOTE_DB, NoteDbTable.CHANGES.key(), SEQUENCE, false);
        this.changePrimaryStorage = cfg.getEnum(NOTE_DB, NoteDbTable.CHANGES.key(), PRIMARY_STORAGE, NoteDbChangeState.PrimaryStorage.REVIEW_DB);
        this.disableChangeReviewDb = cfg.getBoolean(NOTE_DB, NoteDbTable.CHANGES.key(), DISABLE_REVIEW_DB, false);
        Preconditions.checkArgument(!this.disableChangeReviewDb || this.changePrimaryStorage == NoteDbChangeState.PrimaryStorage.NOTE_DB, "cannot disable ReviewDb for changes if default change primary storage is ReviewDb");
    }

    @Override
    protected boolean writeChanges() {
        return this.writeChanges;
    }

    @Override
    public boolean readChanges() {
        return this.readChanges;
    }

    @Override
    public boolean readChangeSequence() {
        return this.readChangeSequence;
    }

    @Override
    public NoteDbChangeState.PrimaryStorage changePrimaryStorage() {
        return this.changePrimaryStorage;
    }

    @Override
    public boolean disableChangeReviewDb() {
        return this.disableChangeReviewDb;
    }

    public static class Module
    extends AbstractModule {
        @Override
        public void configure() {
            this.bind(NotesMigration.class).to(ConfigNotesMigration.class);
        }
    }
}

