/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.git.RepoRefCache;
import com.google.gerrit.server.notedb.AbstractChangeNotes;
import com.google.gerrit.server.notedb.ChangeNotesCommit;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DraftCommentNotes
extends AbstractChangeNotes<DraftCommentNotes> {
    private static final Logger log = LoggerFactory.getLogger(DraftCommentNotes.class);
    private final Change change;
    private final Account.Id author;
    private final NoteDbUpdateManager.Result rebuildResult;
    private final Ref ref;
    private ImmutableListMultimap<RevId, Comment> comments;
    private RevisionNoteMap<ChangeRevisionNote> revisionNoteMap;

    @AssistedInject
    DraftCommentNotes(AbstractChangeNotes.Args args, @Assisted Change change, @Assisted Account.Id author) {
        this(args, change, author, true, null, null);
    }

    @AssistedInject
    DraftCommentNotes(AbstractChangeNotes.Args args, @Assisted Change.Id changeId, @Assisted Account.Id author) {
        super(args, changeId, null, false);
        this.change = null;
        this.author = author;
        this.rebuildResult = null;
        this.ref = null;
    }

    DraftCommentNotes(AbstractChangeNotes.Args args, Change change, Account.Id author, boolean autoRebuild, @Nullable NoteDbUpdateManager.Result rebuildResult, @Nullable Ref ref) {
        super(args, change.getId(), NoteDbChangeState.PrimaryStorage.of(change), autoRebuild);
        this.change = change;
        this.author = author;
        this.rebuildResult = rebuildResult;
        this.ref = ref;
        if (ref != null) {
            Preconditions.checkArgument(ref.getName().equals(this.getRefName()), "draft ref not for change %s and account %s: %s", (Object)this.getChangeId(), (Object)author, (Object)ref.getName());
        }
    }

    RevisionNoteMap<ChangeRevisionNote> getRevisionNoteMap() {
        return this.revisionNoteMap;
    }

    public Account.Id getAuthor() {
        return this.author;
    }

    public ImmutableListMultimap<RevId, Comment> getComments() {
        return this.comments;
    }

    public boolean containsComment(Comment c) {
        for (Comment existing : this.comments.values()) {
            if (!c.key.equals(existing.key)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getRefName() {
        return RefNames.refsDraftComments(this.getChangeId(), this.author);
    }

    @Override
    protected ObjectId readRef(Repository repo) throws IOException {
        if (this.ref != null) {
            return this.ref.getObjectId();
        }
        return super.readRef(repo);
    }

    @Override
    protected void onLoad(AbstractChangeNotes.LoadHandle handle) throws IOException, ConfigInvalidException {
        ObjectId rev = handle.id();
        if (rev == null) {
            this.loadDefaults();
            return;
        }
        ChangeNotesCommit tipCommit = handle.walk().parseCommit(rev);
        ObjectReader reader = handle.walk().getObjectReader();
        this.revisionNoteMap = RevisionNoteMap.parse(this.args.noteUtil, this.getChangeId(), reader, NoteMap.read(reader, tipCommit), PatchLineComment.Status.DRAFT);
        Multimap cs = MultimapBuilder.hashKeys().arrayListValues().build();
        for (ChangeRevisionNote rn : this.revisionNoteMap.revisionNotes.values()) {
            for (Comment c : rn.getComments()) {
                cs.put(new RevId(c.revId), c);
            }
        }
        this.comments = ImmutableListMultimap.copyOf(cs);
    }

    @Override
    protected void loadDefaults() {
        this.comments = ImmutableListMultimap.of();
    }

    @Override
    public Project.NameKey getProjectName() {
        return this.args.allUsers;
    }

    @Override
    protected AbstractChangeNotes.LoadHandle openHandle(Repository repo) throws NoSuchChangeException, IOException {
        NoteDbChangeState state;
        if (this.rebuildResult != null) {
            NoteDbUpdateManager.StagedResult sr = Preconditions.checkNotNull(this.rebuildResult.staged());
            return AbstractChangeNotes.LoadHandle.create(ChangeNotesCommit.newStagedRevWalk(repo, sr.allUsersObjects()), DraftCommentNotes.findNewId(sr.allUsersCommands(), this.getRefName()));
        }
        if (this.change != null && this.autoRebuild && !NoteDbChangeState.areDraftsUpToDate(state = NoteDbChangeState.parse(this.change), new RepoRefCache(repo), this.getChangeId(), this.author)) {
            return this.rebuildAndOpen(repo);
        }
        return super.openHandle(repo);
    }

    private static ObjectId findNewId(Iterable<ReceiveCommand> cmds, String refName) {
        for (ReceiveCommand cmd : cmds) {
            if (!cmd.getRefName().equals(refName)) continue;
            return cmd.getNewId();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AbstractChangeNotes.LoadHandle rebuildAndOpen(Repository repo) throws NoSuchChangeException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ObjectId draftsId(NoteDbUpdateManager.Result r) {
        Preconditions.checkNotNull(r);
        Preconditions.checkNotNull(r.newState());
        return r.newState().getDraftIds().get(this.author);
    }

    @VisibleForTesting
    NoteMap getNoteMap() {
        return this.revisionNoteMap != null ? this.revisionNoteMap.noteMap : null;
    }

    public static interface Factory {
        public DraftCommentNotes create(Change var1, Account.Id var2);

        public DraftCommentNotes createWithAutoRebuildingDisabled(Change.Id var1, Account.Id var2);
    }
}

