/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.base.Preconditions;
import com.google.gerrit.server.ioutil.BasicSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ComparisonType {
    private final Integer parentNum;
    private final boolean autoMerge;

    public static ComparisonType againstOtherPatchSet() {
        return new ComparisonType(null, false);
    }

    public static ComparisonType againstParent(int parentNum) {
        return new ComparisonType(parentNum, false);
    }

    public static ComparisonType againstAutoMerge() {
        return new ComparisonType(null, true);
    }

    private ComparisonType(Integer parentNum, boolean autoMerge) {
        this.parentNum = parentNum;
        this.autoMerge = autoMerge;
    }

    public boolean isAgainstParentOrAutoMerge() {
        return this.isAgainstParent() || this.isAgainstAutoMerge();
    }

    public boolean isAgainstParent() {
        return this.parentNum != null;
    }

    public boolean isAgainstAutoMerge() {
        return this.autoMerge;
    }

    public int getParentNum() {
        Preconditions.checkNotNull(this.parentNum);
        return this.parentNum;
    }

    void writeTo(OutputStream out) throws IOException {
        BasicSerialization.writeVarInt32(out, this.parentNum != null ? this.parentNum : 0);
        BasicSerialization.writeVarInt32(out, this.autoMerge ? 1 : 0);
    }

    static ComparisonType readFrom(InputStream in) throws IOException {
        int p = BasicSerialization.readVarInt32(in);
        Integer parentNum = p > 0 ? Integer.valueOf(p) : null;
        boolean autoMerge = BasicSerialization.readVarInt32(in) != 0;
        return new ComparisonType(parentNum, autoMerge);
    }
}

