/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.registration.RegistrationHandle;
import com.google.gerrit.extensions.registration.ReloadableRegistrationHandle;
import com.google.gerrit.lifecycle.LifecycleManager;
import com.google.gerrit.server.PluginUser;
import com.google.gerrit.server.plugins.CleanupHandle;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.gerrit.server.plugins.PluginGuiceEnvironment;
import com.google.inject.Injector;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jgit.internal.storage.file.FileSnapshot;

public abstract class Plugin {
    private final String name;
    private final Path srcFile;
    private final ApiType apiType;
    private final boolean disabled;
    private final CacheKey cacheKey;
    private final PluginUser pluginUser;
    private final FileSnapshot snapshot;
    private CleanupHandle cleanupHandle;
    protected LifecycleManager manager;
    private List<ReloadableRegistrationHandle<?>> reloadableHandles;

    static ApiType getApiType(Manifest manifest) throws InvalidPluginException {
        Attributes main = manifest.getMainAttributes();
        String v = main.getValue("Gerrit-ApiType");
        if (Strings.isNullOrEmpty(v) || ApiType.EXTENSION.name().equalsIgnoreCase(v)) {
            return ApiType.EXTENSION;
        }
        if (ApiType.PLUGIN.name().equalsIgnoreCase(v)) {
            return ApiType.PLUGIN;
        }
        if (ApiType.JS.name().equalsIgnoreCase(v)) {
            return ApiType.JS;
        }
        throw new InvalidPluginException("Invalid Gerrit-ApiType: " + v);
    }

    public Plugin(String name, Path srcPath, PluginUser pluginUser, FileSnapshot snapshot, ApiType apiType) {
        this.name = name;
        this.srcFile = srcPath;
        this.apiType = apiType;
        this.snapshot = snapshot;
        this.pluginUser = pluginUser;
        this.cacheKey = new CacheKey(name);
        this.disabled = srcPath != null && srcPath.getFileName().toString().endsWith(".disabled");
    }

    public CleanupHandle getCleanupHandle() {
        return this.cleanupHandle;
    }

    public void setCleanupHandle(CleanupHandle cleanupHandle) {
        this.cleanupHandle = cleanupHandle;
    }

    PluginUser getPluginUser() {
        return this.pluginUser;
    }

    public Path getSrcFile() {
        return this.srcFile;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public abstract String getVersion();

    public ApiType getApiType() {
        return this.apiType;
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    protected abstract void start(PluginGuiceEnvironment var1) throws Exception;

    protected abstract void stop(PluginGuiceEnvironment var1);

    public abstract PluginContentScanner getContentScanner();

    public abstract Injector getSysInjector();

    @Nullable
    public abstract Injector getSshInjector();

    @Nullable
    public abstract Injector getHttpInjector();

    public void add(RegistrationHandle handle) {
        if (this.manager != null) {
            if (handle instanceof ReloadableRegistrationHandle) {
                if (this.reloadableHandles == null) {
                    this.reloadableHandles = new ArrayList();
                }
                this.reloadableHandles.add((ReloadableRegistrationHandle)handle);
            }
            this.manager.add(handle);
        }
    }

    List<ReloadableRegistrationHandle<?>> getReloadableHandles() {
        if (this.reloadableHandles != null) {
            return this.reloadableHandles;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "Plugin [" + this.name + "]";
    }

    protected abstract boolean canReload();

    boolean isModified(Path jar) {
        return this.snapshot.isModified(jar.toFile());
    }

    public static final class CacheKey {
        private final String name;

        CacheKey(String name) {
            this.name = name;
        }

        public String toString() {
            int id = System.identityHashCode(this);
            return String.format("Plugin[%s@%x]", this.name, id);
        }
    }

    public static enum ApiType {
        EXTENSION,
        PLUGIN,
        JS;

    }
}

