/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.DeleteRef;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class DeleteBranch
implements RestModifyView<BranchResource, Input> {
    private final Provider<InternalChangeQuery> queryProvider;
    private final DeleteRef.Factory deleteRefFactory;

    @Inject
    DeleteBranch(Provider<InternalChangeQuery> queryProvider, DeleteRef.Factory deleteRefFactory) {
        this.queryProvider = queryProvider;
        this.deleteRefFactory = deleteRefFactory;
    }

    public Response<?> apply(BranchResource rsrc, Input input) throws RestApiException, OrmException, IOException {
        if (!rsrc.getControl().controlForRef(rsrc.getBranchKey()).canDelete()) {
            throw new AuthException("Cannot delete branch");
        }
        if (!this.queryProvider.get().setLimit(1).byBranchOpen(rsrc.getBranchKey()).isEmpty()) {
            throw new ResourceConflictException("branch " + rsrc.getBranchKey() + " has open changes");
        }
        this.deleteRefFactory.create(rsrc).ref(rsrc.getRef()).prefix("refs/heads/").delete();
        return Response.none();
    }

    public static class Input {
    }
}

