/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.project.AutoValue_PermissionCollection_SeenRule;
import com.google.gerrit.server.project.ProjectRef;
import com.google.gerrit.server.project.RefPattern;
import com.google.gerrit.server.project.RefPatternMatcher;
import com.google.gerrit.server.project.SectionMatcher;
import com.google.gerrit.server.project.SectionSortCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PermissionCollection {
    private final Map<String, List<PermissionRule>> rules;
    private final Map<String, List<PermissionRule>> overridden;
    private final Map<PermissionRule, ProjectRef> ruleProps;
    private final boolean perUser;

    private PermissionCollection(Map<String, List<PermissionRule>> rules, Map<String, List<PermissionRule>> overridden, Map<PermissionRule, ProjectRef> ruleProps, boolean perUser) {
        this.rules = rules;
        this.overridden = overridden;
        this.ruleProps = ruleProps;
        this.perUser = perUser;
    }

    public boolean isUserSpecific() {
        return this.perUser;
    }

    public List<PermissionRule> getPermission(String permissionName) {
        List<PermissionRule> r = this.rules.get(permissionName);
        return r != null ? r : Collections.emptyList();
    }

    List<PermissionRule> getOverridden(String permissionName) {
        return MoreObjects.firstNonNull(this.overridden.get(permissionName), Collections.emptyList());
    }

    ProjectRef getRuleProps(PermissionRule rule) {
        return this.ruleProps.get(rule);
    }

    public Iterable<Map.Entry<String, List<PermissionRule>>> getDeclaredPermissions() {
        return this.rules.entrySet();
    }

    @AutoValue
    static abstract class SeenRule {
        SeenRule() {
        }

        public abstract String refPattern();

        public abstract String permissionName();

        @Nullable
        public abstract AccountGroup.UUID group();

        static SeenRule create(AccessSection section, Permission permission, @Nullable PermissionRule rule) {
            AccountGroup.UUID group = rule != null && rule.getGroup() != null ? rule.getGroup().getUUID() : null;
            return new AutoValue_PermissionCollection_SeenRule(section.getName(), permission.getName(), group);
        }
    }

    @Singleton
    public static class Factory {
        private final SectionSortCache sorter;

        @Inject
        Factory(SectionSortCache sorter) {
            this.sorter = sorter;
        }

        PermissionCollection filter(Iterable<SectionMatcher> matcherList, String ref, CurrentUser user) {
            if (RefPattern.isRE(ref)) {
                ref = RefPattern.shortestExample(ref);
            } else if (ref.endsWith("/*")) {
                ref = ref.substring(0, ref.length() - 1);
            }
            boolean perUser = false;
            LinkedHashMap<AccessSection, Project.NameKey> sectionToProject = new LinkedHashMap<AccessSection, Project.NameKey>();
            for (SectionMatcher sm : matcherList) {
                if (sm.matcher instanceof RefPatternMatcher.ExpandParameters) {
                    if (!((RefPatternMatcher.ExpandParameters)sm.matcher).matchPrefix(ref)) continue;
                    perUser = true;
                    if (!sm.match(ref, user)) continue;
                    sectionToProject.put(sm.section, sm.project);
                    continue;
                }
                if (!sm.match(ref, null)) continue;
                sectionToProject.put(sm.section, sm.project);
            }
            ArrayList<AccessSection> sections = Lists.newArrayList(sectionToProject.keySet());
            this.sorter.sort(ref, sections);
            HashSet<SeenRule> seen = new HashSet<SeenRule>();
            HashSet<String> exclusiveGroupPermissions = new HashSet<String>();
            HashMap<String, ArrayList<PermissionRule>> permissions = new HashMap<String, ArrayList<PermissionRule>>();
            HashMap overridden = new HashMap();
            IdentityHashMap<PermissionRule, ProjectRef> ruleProps = Maps.newIdentityHashMap();
            Multimap exclusivePermissionsByProject = MultimapBuilder.hashKeys().arrayListValues().build();
            for (AccessSection section : sections) {
                Project.NameKey project = (Project.NameKey)sectionToProject.get(section);
                for (Permission permission : section.getPermissions()) {
                    boolean exclusivePermissionExists = exclusiveGroupPermissions.contains(permission.getName());
                    for (PermissionRule rule : permission.getRules()) {
                        SeenRule s = SeenRule.create(section, permission, rule);
                        boolean addRule = rule.isBlock() ? !exclusivePermissionsByProject.containsEntry(project, permission.getName()) : seen.add(s) && !rule.isDeny() && !exclusivePermissionExists;
                        HashMap<String, ArrayList<PermissionRule>> p = null;
                        if (addRule) {
                            p = permissions;
                        } else if (!rule.isDeny() && !exclusivePermissionExists) {
                            p = overridden;
                        }
                        if (p == null) continue;
                        ArrayList<PermissionRule> r = (ArrayList<PermissionRule>)p.get(permission.getName());
                        if (r == null) {
                            r = new ArrayList<PermissionRule>(2);
                            p.put(permission.getName(), r);
                        }
                        r.add(rule);
                        ruleProps.put(rule, ProjectRef.create(project, section.getName()));
                    }
                    if (!permission.getExclusiveGroup().booleanValue()) continue;
                    exclusivePermissionsByProject.put(project, permission.getName());
                    exclusiveGroupPermissions.add(permission.getName());
                }
            }
            return new PermissionCollection(permissions, overridden, ruleProps, perUser);
        }
    }
}

