/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.gerrit.extensions.api.projects.RefInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.List;
import java.util.Locale;

public class RefFilter<T extends RefInfo> {
    private final String prefix;
    private String matchSubstring;
    private String matchRegex;
    private int start;
    private int limit;

    public RefFilter(String prefix) {
        this.prefix = prefix;
    }

    public RefFilter<T> subString(String subString) {
        this.matchSubstring = subString;
        return this;
    }

    public RefFilter<T> regex(String regex) {
        this.matchRegex = regex;
        return this;
    }

    public RefFilter<T> start(int start) {
        this.start = start;
        return this;
    }

    public RefFilter<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public List<T> filter(List<T> refs) throws BadRequestException {
        if (!Strings.isNullOrEmpty(this.matchSubstring) && !Strings.isNullOrEmpty(this.matchRegex)) {
            throw new BadRequestException("specify exactly one of m/r");
        }
        FluentIterable<T> results = FluentIterable.from(refs);
        if (!Strings.isNullOrEmpty(this.matchSubstring)) {
            results = results.filter(new SubstringPredicate(this.matchSubstring));
        } else if (!Strings.isNullOrEmpty(this.matchRegex)) {
            results = results.filter(new RegexPredicate(this.matchRegex));
        }
        if (this.start > 0) {
            results = results.skip(this.start);
        }
        if (this.limit > 0) {
            results = results.limit(this.limit);
        }
        return results.toList();
    }

    private class RegexPredicate
    implements Predicate<T> {
        private final RunAutomaton a;

        private RegexPredicate(String regex) throws BadRequestException {
            if (regex.startsWith("^") && (regex = regex.substring(1)).endsWith("$") && !regex.endsWith("\\$")) {
                regex = regex.substring(0, regex.length() - 1);
            }
            try {
                this.a = new RunAutomaton(new RegExp(regex).toAutomaton());
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e.getMessage());
            }
        }

        @Override
        public boolean apply(T in) {
            String ref = ((RefInfo)in).ref;
            if (ref.startsWith(RefFilter.this.prefix)) {
                ref = ref.substring(RefFilter.this.prefix.length());
            }
            return this.a.run(ref);
        }
    }

    private class SubstringPredicate
    implements Predicate<T> {
        private final String substring;

        private SubstringPredicate(String substring) {
            this.substring = substring.toLowerCase(Locale.US);
        }

        @Override
        public boolean apply(T in) {
            String ref = ((RefInfo)in).ref;
            if (ref.startsWith(RefFilter.this.prefix)) {
                ref = ref.substring(RefFilter.this.prefix.length());
            }
            ref = ref.toLowerCase(Locale.US);
            return ref.contains(this.substring);
        }
    }
}

