/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.account;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.index.IndexConfig;
import com.google.gerrit.server.index.account.AccountIndexCollection;
import com.google.gerrit.server.query.InternalQuery;
import com.google.gerrit.server.query.account.AccountPredicates;
import com.google.gerrit.server.query.account.AccountQueryProcessor;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalAccountQuery
extends InternalQuery<AccountState> {
    private static final Logger log = LoggerFactory.getLogger(InternalAccountQuery.class);

    @Inject
    InternalAccountQuery(AccountQueryProcessor queryProcessor, AccountIndexCollection indexes, IndexConfig indexConfig) {
        super(queryProcessor, indexes, indexConfig);
    }

    public InternalAccountQuery setLimit(int n) {
        super.setLimit(n);
        return this;
    }

    public InternalAccountQuery enforceVisibility(boolean enforce) {
        super.enforceVisibility(enforce);
        return this;
    }

    public InternalAccountQuery setRequestedFields(Set<String> fields) {
        super.setRequestedFields(fields);
        return this;
    }

    public InternalAccountQuery noFields() {
        super.noFields();
        return this;
    }

    public List<AccountState> byDefault(String query) throws OrmException {
        return this.query(AccountPredicates.defaultPredicate(query));
    }

    public List<AccountState> byEmailPrefix(String emailPrefix) throws OrmException {
        return this.query(AccountPredicates.email(emailPrefix));
    }

    public List<AccountState> byExternalId(String scheme, String id) throws OrmException {
        return this.byExternalId(ExternalId.Key.create(scheme, id));
    }

    public List<AccountState> byExternalId(ExternalId.Key externalId) throws OrmException {
        return this.query(AccountPredicates.externalId(externalId.toString()));
    }

    public AccountState oneByExternalId(String externalId) throws OrmException {
        return this.oneByExternalId(ExternalId.Key.parse(externalId));
    }

    public AccountState oneByExternalId(String scheme, String id) throws OrmException {
        return this.oneByExternalId(ExternalId.Key.create(scheme, id));
    }

    public AccountState oneByExternalId(ExternalId.Key externalId) throws OrmException {
        List<AccountState> accountStates = this.byExternalId(externalId);
        if (accountStates.size() == 1) {
            return accountStates.get(0);
        }
        if (accountStates.size() > 0) {
            StringBuilder msg = new StringBuilder();
            msg.append("Ambiguous external ID ").append(externalId).append("for accounts: ");
            Joiner.on(", ").appendTo(msg, (Iterable<?>)Lists.transform(accountStates, AccountState.ACCOUNT_ID_FUNCTION));
            log.warn(msg.toString());
        }
        return null;
    }

    public List<AccountState> byFullName(String fullName) throws OrmException {
        return this.query(AccountPredicates.fullName(fullName));
    }

    public List<AccountState> byWatchedProject(Project.NameKey project) throws OrmException {
        return this.query(AccountPredicates.watchedProject(project));
    }
}

