/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;

class AssigneePredicate
extends ChangeIndexPredicate {
    private final Account.Id id;

    AssigneePredicate(Account.Id id) {
        super(ChangeField.ASSIGNEE, id.toString());
        this.id = id;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        if (this.id.get() == -1) {
            Account.Id assignee = object.change().getAssignee();
            return assignee == null;
        }
        return this.id.equals(object.change().getAssignee());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

