/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.ReviewerStatusUpdate;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.change.MergeabilityCache;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.patch.DiffSummary;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.project.SubmitRuleOptions;
import com.google.gerrit.server.query.change.AutoValue_ChangeData_ReviewedByEvent;
import com.google.gerrit.server.query.change.AutoValue_ChangeData_StarsOf;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ChangeData {
    private static final int BATCH_SIZE = 50;
    private boolean lazyLoad = true;
    private final ReviewDb db;
    private final GitRepositoryManager repoManager;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ProjectCache projectCache;
    private final MergeUtil.Factory mergeUtilFactory;
    private final ChangeNotes.Factory notesFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil cmUtil;
    private final CommentsUtil commentsUtil;
    private final PatchSetUtil psUtil;
    private final PatchListCache patchListCache;
    private final NotesMigration notesMigration;
    private final MergeabilityCache mergeabilityCache;
    private final StarredChangesUtil starredChangesUtil;
    private final Change.Id legacyId;
    private final Map<SubmitRuleOptions, List<SubmitRecord>> submitRecords = Maps.newLinkedHashMapWithExpectedSize(1);
    private Project.NameKey project;
    private Change change;
    private ChangeNotes notes;
    private String commitMessage;
    private List<FooterLine> commitFooters;
    private PatchSet currentPatchSet;
    private Collection<PatchSet> patchSets;
    private ListMultimap<PatchSet.Id, PatchSetApproval> allApprovals;
    private List<PatchSetApproval> currentApprovals;
    private Map<Integer, List<String>> files;
    private Map<Integer, Optional<DiffSummary>> diffSummaries;
    private Collection<Comment> publishedComments;
    private Collection<RobotComment> robotComments;
    private CurrentUser visibleTo;
    private ChangeControl changeControl;
    private List<ChangeMessage> messages;
    private Optional<ChangedLines> changedLines;
    private SubmitTypeRecord submitTypeRecord;
    private Boolean mergeable;
    private Set<String> hashtags;
    private Map<Account.Id, Ref> editsByUser;
    private Set<Account.Id> reviewedBy;
    private Map<Account.Id, Ref> draftsByUser;
    private ImmutableListMultimap<Account.Id, String> stars;
    private StarsOf starsOf;
    private ImmutableMap<Account.Id, StarredChangesUtil.StarRef> starRefs;
    private ReviewerSet reviewers;
    private List<ReviewerStatusUpdate> reviewerUpdates;
    private PersonIdent author;
    private PersonIdent committer;
    private Integer unresolvedCommentCount;
    private ImmutableList<byte[]> refStates;
    private ImmutableList<byte[]> refStatePatterns;

    public static List<Change> asChanges(List<ChangeData> changeDatas) throws OrmException {
        ArrayList<Change> result = new ArrayList<Change>(changeDatas.size());
        for (ChangeData cd : changeDatas) {
            result.add(cd.change());
        }
        return result;
    }

    public static Map<Change.Id, ChangeData> asMap(List<ChangeData> changes) {
        return changes.stream().collect(Collectors.toMap(ChangeData::getId, cd -> cd));
    }

    public static void ensureChangeLoaded(Iterable<ChangeData> changes) throws OrmException {
        ChangeData first = Iterables.getFirst(changes, null);
        if (first == null) {
            return;
        }
        if (first.notesMigration.readChanges()) {
            for (ChangeData cd : changes) {
                cd.change();
            }
            return;
        }
        HashMap<Change.Id, ChangeData> missing = new HashMap<Change.Id, ChangeData>();
        for (ChangeData cd : changes) {
            if (cd.change != null) continue;
            missing.put(cd.getId(), cd);
        }
        if (missing.isEmpty()) {
            return;
        }
        for (ChangeNotes notes : first.notesFactory.create(first.db, missing.keySet())) {
            ((ChangeData)missing.get((Object)notes.getChangeId())).change = notes.getChange();
        }
    }

    public static void ensureAllPatchSetsLoaded(Iterable<ChangeData> changes) throws OrmException {
        ChangeData first = Iterables.getFirst(changes, null);
        if (first == null) {
            return;
        }
        if (first.notesMigration.readChanges()) {
            for (ChangeData cd : changes) {
                cd.patchSets();
            }
            return;
        }
        ArrayList<ResultSet<PatchSet>> results = new ArrayList<ResultSet<PatchSet>>(50);
        for (List<ChangeData> batch : Iterables.partition(changes, 50)) {
            results.clear();
            for (ChangeData cd : batch) {
                if (cd.patchSets == null) {
                    results.add(cd.db.patchSets().byChange(cd.getId()));
                    continue;
                }
                results.add(null);
            }
            for (int i = 0; i < batch.size(); ++i) {
                ResultSet result = (ResultSet)results.get(i);
                if (result == null) continue;
                batch.get((int)i).patchSets = result.toList();
            }
        }
    }

    public static void ensureCurrentPatchSetLoaded(Iterable<ChangeData> changes) throws OrmException {
        ChangeData first = Iterables.getFirst(changes, null);
        if (first == null) {
            return;
        }
        if (first.notesMigration.readChanges()) {
            for (ChangeData cd : changes) {
                cd.currentPatchSet();
            }
            return;
        }
        HashMap<PatchSet.Id, ChangeData> missing = new HashMap<PatchSet.Id, ChangeData>();
        for (ChangeData cd : changes) {
            if (cd.currentPatchSet != null || cd.patchSets != null) continue;
            missing.put(cd.change().currentPatchSetId(), cd);
        }
        if (missing.isEmpty()) {
            return;
        }
        Iterator<ChangeData> iterator = first.db.patchSets().get(missing.keySet()).iterator();
        while (iterator.hasNext()) {
            PatchSet ps;
            ((ChangeData)missing.get((Object)ps.getId())).currentPatchSet = ps = (PatchSet)((Object)iterator.next());
        }
    }

    public static void ensureCurrentApprovalsLoaded(Iterable<ChangeData> changes) throws OrmException {
        ChangeData first = Iterables.getFirst(changes, null);
        if (first == null) {
            return;
        }
        if (first.notesMigration.readChanges()) {
            for (ChangeData cd : changes) {
                cd.currentApprovals();
            }
            return;
        }
        ArrayList<ResultSet<PatchSetApproval>> results = new ArrayList<ResultSet<PatchSetApproval>>(50);
        for (List<ChangeData> batch : Iterables.partition(changes, 50)) {
            results.clear();
            for (ChangeData cd : batch) {
                if (cd.currentApprovals == null) {
                    PatchSet.Id psId = cd.change().currentPatchSetId();
                    results.add(cd.db.patchSetApprovals().byPatchSet(psId));
                    continue;
                }
                results.add(null);
            }
            for (int i = 0; i < batch.size(); ++i) {
                ResultSet result = (ResultSet)results.get(i);
                if (result == null) continue;
                batch.get((int)i).currentApprovals = ApprovalsUtil.sortApprovals(result);
            }
        }
    }

    public static void ensureMessagesLoaded(Iterable<ChangeData> changes) throws OrmException {
        ChangeData first = Iterables.getFirst(changes, null);
        if (first == null) {
            return;
        }
        if (first.notesMigration.readChanges()) {
            for (ChangeData cd : changes) {
                cd.messages();
            }
            return;
        }
        ArrayList<ResultSet<ChangeMessage>> results = new ArrayList<ResultSet<ChangeMessage>>(50);
        for (List<ChangeData> batch : Iterables.partition(changes, 50)) {
            results.clear();
            for (ChangeData cd : batch) {
                if (cd.messages == null) {
                    PatchSet.Id psId = cd.change().currentPatchSetId();
                    results.add(cd.db.changeMessages().byPatchSet(psId));
                    continue;
                }
                results.add(null);
            }
            for (int i = 0; i < batch.size(); ++i) {
                ResultSet result = (ResultSet)results.get(i);
                if (result == null) continue;
                batch.get((int)i).messages = result.toList();
            }
        }
    }

    public static void ensureReviewedByLoadedForOpenChanges(Iterable<ChangeData> changes) throws OrmException {
        ArrayList<ChangeData> pending = new ArrayList<ChangeData>();
        for (ChangeData cd : changes) {
            if (cd.reviewedBy != null || !cd.change().getStatus().isOpen()) continue;
            pending.add(cd);
        }
        if (!pending.isEmpty()) {
            ChangeData.ensureAllPatchSetsLoaded(pending);
            ChangeData.ensureMessagesLoaded(pending);
            for (ChangeData cd : pending) {
                cd.reviewedBy();
            }
        }
    }

    public static ChangeData createForTest(Project.NameKey project, Change.Id id, int currentPatchSetId) {
        ChangeData cd = new ChangeData(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, project, id);
        cd.currentPatchSet = new PatchSet(new PatchSet.Id(id, currentPatchSetId));
        return cd;
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CommentsUtil commentsUtil, PatchSetUtil psUtil, PatchListCache patchListCache, NotesMigration notesMigration, MergeabilityCache mergeabilityCache, @Nullable StarredChangesUtil starredChangesUtil, @Assisted ReviewDb db, @Assisted Project.NameKey project, @Assisted Change.Id id) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.mergeabilityCache = mergeabilityCache;
        this.starredChangesUtil = starredChangesUtil;
        this.project = project;
        this.legacyId = id;
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CommentsUtil commentsUtil, PatchSetUtil psUtil, PatchListCache patchListCache, NotesMigration notesMigration, MergeabilityCache mergeabilityCache, @Nullable StarredChangesUtil starredChangesUtil, @Assisted ReviewDb db, @Assisted Change c) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.mergeabilityCache = mergeabilityCache;
        this.starredChangesUtil = starredChangesUtil;
        this.legacyId = c.getId();
        this.change = c;
        this.project = c.getProject();
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CommentsUtil commentsUtil, PatchSetUtil psUtil, PatchListCache patchListCache, NotesMigration notesMigration, MergeabilityCache mergeabilityCache, @Nullable StarredChangesUtil starredChangesUtil, @Assisted ReviewDb db, @Assisted ChangeNotes cn) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.mergeabilityCache = mergeabilityCache;
        this.starredChangesUtil = starredChangesUtil;
        this.legacyId = cn.getChangeId();
        this.change = cn.getChange();
        this.project = cn.getProjectName();
        this.notes = cn;
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CommentsUtil commentsUtil, PatchSetUtil psUtil, PatchListCache patchListCache, NotesMigration notesMigration, MergeabilityCache mergeabilityCache, @Nullable StarredChangesUtil starredChangesUtil, @Assisted ReviewDb db, @Assisted ChangeControl c) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.mergeabilityCache = mergeabilityCache;
        this.starredChangesUtil = starredChangesUtil;
        this.legacyId = c.getId();
        this.change = c.getChange();
        this.changeControl = c;
        this.notes = c.getNotes();
        this.project = this.notes.getProjectName();
    }

    @AssistedInject
    private ChangeData(GitRepositoryManager repoManager, ChangeControl.GenericFactory changeControlFactory, IdentifiedUser.GenericFactory userFactory, ProjectCache projectCache, MergeUtil.Factory mergeUtilFactory, ChangeNotes.Factory notesFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CommentsUtil commentsUtil, PatchSetUtil psUtil, PatchListCache patchListCache, NotesMigration notesMigration, MergeabilityCache mergeabilityCache, @Nullable StarredChangesUtil starredChangesUtil, @Assisted ReviewDb db, @Assisted Change.Id id) {
        Preconditions.checkState(!notesMigration.readChanges(), "do not call createOnlyWhenNoteDbDisabled when NoteDb is enabled");
        this.db = db;
        this.repoManager = repoManager;
        this.changeControlFactory = changeControlFactory;
        this.userFactory = userFactory;
        this.projectCache = projectCache;
        this.mergeUtilFactory = mergeUtilFactory;
        this.notesFactory = notesFactory;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.patchListCache = patchListCache;
        this.notesMigration = notesMigration;
        this.mergeabilityCache = mergeabilityCache;
        this.starredChangesUtil = starredChangesUtil;
        this.legacyId = id;
        this.project = null;
    }

    public ChangeData setLazyLoad(boolean load) {
        this.lazyLoad = load;
        return this;
    }

    public ReviewDb db() {
        return this.db;
    }

    private Map<Integer, List<String>> initFiles() {
        if (this.files == null) {
            this.files = new HashMap<Integer, List<String>>();
        }
        return this.files;
    }

    public void setCurrentFilePaths(List<String> filePaths) throws OrmException {
        PatchSet ps = this.currentPatchSet();
        if (ps != null) {
            this.initFiles().put(ps.getPatchSetId(), ImmutableList.copyOf(filePaths));
        }
    }

    public List<String> currentFilePaths() throws OrmException {
        PatchSet ps = this.currentPatchSet();
        return ps != null ? this.filePaths(ps) : null;
    }

    public List<String> filePaths(PatchSet ps) throws OrmException {
        Integer psId = ps.getPatchSetId();
        List<String> r = this.initFiles().get(psId);
        if (r == null) {
            Change c = this.change();
            if (c == null) {
                return null;
            }
            Optional<DiffSummary> p = this.getDiffSummary(c, ps);
            if (!p.isPresent()) {
                List<String> emptyFileList = Collections.emptyList();
                if (this.lazyLoad) {
                    this.files.put(ps.getPatchSetId(), emptyFileList);
                }
                return emptyFileList;
            }
            r = p.get().getPaths();
            this.files.put(psId, r);
        }
        return r;
    }

    private Optional<DiffSummary> getDiffSummary(Change c, PatchSet ps) {
        Optional<DiffSummary> r;
        Integer psId = ps.getId().get();
        if (this.diffSummaries == null) {
            this.diffSummaries = new HashMap<Integer, Optional<DiffSummary>>();
        }
        if ((r = this.diffSummaries.get(psId)) == null) {
            if (!this.lazyLoad) {
                return Optional.empty();
            }
            try {
                r = Optional.of(this.patchListCache.getDiffSummary(c, ps));
            }
            catch (PatchListNotAvailableException e) {
                r = Optional.empty();
            }
            this.diffSummaries.put(psId, r);
        }
        return r;
    }

    private Optional<ChangedLines> computeChangedLines() throws OrmException {
        Change c = this.change();
        if (c == null) {
            return Optional.empty();
        }
        PatchSet ps = this.currentPatchSet();
        if (ps == null) {
            return Optional.empty();
        }
        Optional<DiffSummary> ds = this.getDiffSummary(c, ps);
        if (ds.isPresent()) {
            return Optional.of(ds.get().getChangedLines());
        }
        return Optional.empty();
    }

    public Optional<ChangedLines> changedLines() throws OrmException {
        if (this.changedLines == null) {
            if (!this.lazyLoad) {
                return Optional.empty();
            }
            this.changedLines = this.computeChangedLines();
        }
        return this.changedLines;
    }

    public void setChangedLines(int insertions, int deletions) {
        this.changedLines = Optional.of(new ChangedLines(insertions, deletions));
    }

    public void setNoChangedLines() {
        this.changedLines = Optional.empty();
    }

    public Change.Id getId() {
        return this.legacyId;
    }

    public Project.NameKey project() throws OrmException {
        if (this.project == null) {
            Preconditions.checkState(!this.notesMigration.readChanges(), "should not have created  ChangeData without a project when NoteDb is enabled");
            this.project = this.change().getProject();
        }
        return this.project;
    }

    boolean fastIsVisibleTo(CurrentUser user) {
        return this.visibleTo == user;
    }

    public boolean hasChangeControl() {
        return this.changeControl != null;
    }

    public ChangeControl changeControl() throws OrmException {
        if (this.changeControl == null) {
            Change c = this.change();
            try {
                this.changeControl = this.changeControlFactory.controlFor(this.db, c, this.userFactory.create(c.getOwner()));
            }
            catch (NoSuchChangeException e) {
                throw new OrmException(e);
            }
        }
        return this.changeControl;
    }

    public ChangeControl changeControl(CurrentUser user) throws OrmException {
        if (this.changeControl != null) {
            CurrentUser oldUser = user;
            if (ChangeData.sameUser(user, oldUser)) {
                return this.changeControl;
            }
            throw new IllegalStateException("user already specified: " + this.changeControl.getUser());
        }
        try {
            this.changeControl = this.change != null ? this.changeControlFactory.controlFor(this.db, this.change, user) : this.changeControlFactory.controlFor(this.db, this.project(), this.legacyId, user);
        }
        catch (NoSuchChangeException e) {
            throw new OrmException(e);
        }
        return this.changeControl;
    }

    private static boolean sameUser(CurrentUser a, CurrentUser b) {
        if (a.isInternalUser() && b.isInternalUser()) {
            return true;
        }
        if (a instanceof AnonymousUser && b instanceof AnonymousUser) {
            return true;
        }
        if (a.isIdentifiedUser() && b.isIdentifiedUser()) {
            return a.getAccountId().equals(b.getAccountId());
        }
        return false;
    }

    void cacheVisibleTo(ChangeControl ctl) {
        this.visibleTo = ctl.getUser();
        this.changeControl = ctl;
    }

    public Change change() throws OrmException {
        if (this.change == null && this.lazyLoad) {
            this.reloadChange();
        }
        return this.change;
    }

    public void setChange(Change c) {
        this.change = c;
    }

    public Change reloadChange() throws OrmException {
        try {
            this.notes = this.notesFactory.createChecked(this.db, this.project, this.legacyId);
        }
        catch (NoSuchChangeException e) {
            throw new OrmException("Unable to load change " + this.legacyId, e);
        }
        this.change = this.notes.getChange();
        this.setPatchSets(null);
        return this.change;
    }

    public ChangeNotes notes() throws OrmException {
        if (this.notes == null) {
            if (!this.lazyLoad) {
                throw new OrmException("ChangeNotes not available, lazyLoad = false");
            }
            this.notes = this.notesFactory.create(this.db, this.project(), this.legacyId);
        }
        return this.notes;
    }

    public PatchSet currentPatchSet() throws OrmException {
        if (this.currentPatchSet == null) {
            Change c = this.change();
            if (c == null) {
                return null;
            }
            for (PatchSet p : this.patchSets()) {
                if (!p.getId().equals(c.currentPatchSetId())) continue;
                this.currentPatchSet = p;
                return p;
            }
        }
        return this.currentPatchSet;
    }

    public List<PatchSetApproval> currentApprovals() throws OrmException {
        if (this.currentApprovals == null) {
            if (!this.lazyLoad) {
                return Collections.emptyList();
            }
            Change c = this.change();
            if (c == null) {
                this.currentApprovals = Collections.emptyList();
            } else {
                try {
                    this.currentApprovals = ImmutableList.copyOf(this.approvalsUtil.byPatchSet(this.db, this.changeControl(), c.currentPatchSetId()));
                }
                catch (OrmException e) {
                    if (e.getCause() instanceof NoSuchChangeException) {
                        this.currentApprovals = Collections.emptyList();
                    }
                    throw e;
                }
            }
        }
        return this.currentApprovals;
    }

    public void setCurrentApprovals(List<PatchSetApproval> approvals) {
        this.currentApprovals = approvals;
    }

    public String commitMessage() throws IOException, OrmException {
        if (this.commitMessage == null && !this.loadCommitData()) {
            return null;
        }
        return this.commitMessage;
    }

    public List<FooterLine> commitFooters() throws IOException, OrmException {
        if (this.commitFooters == null && !this.loadCommitData()) {
            return null;
        }
        return this.commitFooters;
    }

    public PersonIdent getAuthor() throws IOException, OrmException {
        if (this.author == null && !this.loadCommitData()) {
            return null;
        }
        return this.author;
    }

    public PersonIdent getCommitter() throws IOException, OrmException {
        if (this.committer == null && !this.loadCommitData()) {
            return null;
        }
        return this.committer;
    }

    private boolean loadCommitData() throws OrmException, RepositoryNotFoundException, IOException, MissingObjectException, IncorrectObjectTypeException {
        PatchSet ps = this.currentPatchSet();
        if (ps == null) {
            return false;
        }
        String sha1 = ps.getRevision().get();
        try (Repository repo = this.repoManager.openRepository(this.project());
             RevWalk walk = new RevWalk(repo);){
            RevCommit c = walk.parseCommit(ObjectId.fromString(sha1));
            this.commitMessage = c.getFullMessage();
            this.commitFooters = c.getFooterLines();
            this.author = c.getAuthorIdent();
            this.committer = c.getCommitterIdent();
        }
        return true;
    }

    public Collection<PatchSet> patchSets() throws OrmException {
        if (this.patchSets == null) {
            this.patchSets = this.psUtil.byChange(this.db, this.notes());
        }
        return this.patchSets;
    }

    public Collection<PatchSet> visiblePatchSets() throws OrmException {
        Predicate<PatchSet> predicate = ps -> {
            try {
                return this.changeControl().isPatchVisible((PatchSet)ps, this.db);
            }
            catch (OrmException e) {
                return false;
            }
        };
        return this.patchSets().stream().filter(predicate).collect(Collectors.toList());
    }

    public void setPatchSets(Collection<PatchSet> patchSets) {
        this.currentPatchSet = null;
        this.patchSets = patchSets;
    }

    public PatchSet patchSet(PatchSet.Id psId) throws OrmException {
        if (this.currentPatchSet != null && this.currentPatchSet.getId().equals(psId)) {
            return this.currentPatchSet;
        }
        for (PatchSet ps : this.patchSets()) {
            if (!ps.getId().equals(psId)) continue;
            return ps;
        }
        return null;
    }

    public ListMultimap<PatchSet.Id, PatchSetApproval> approvals() throws OrmException {
        if (this.allApprovals == null) {
            if (!this.lazyLoad) {
                return ImmutableListMultimap.of();
            }
            this.allApprovals = this.approvalsUtil.byChange(this.db, this.notes());
        }
        return this.allApprovals;
    }

    public Optional<PatchSetApproval> getSubmitApproval() throws OrmException {
        return this.currentApprovals().stream().filter(PatchSetApproval::isLegacySubmit).findFirst();
    }

    public ReviewerSet reviewers() throws OrmException {
        if (this.reviewers == null) {
            if (!this.lazyLoad) {
                return ReviewerSet.empty();
            }
            this.reviewers = this.approvalsUtil.getReviewers(this.notes(), this.approvals().values());
        }
        return this.reviewers;
    }

    public void setReviewers(ReviewerSet reviewers) {
        this.reviewers = reviewers;
    }

    public ReviewerSet getReviewers() {
        return this.reviewers;
    }

    public List<ReviewerStatusUpdate> reviewerUpdates() throws OrmException {
        if (this.reviewerUpdates == null) {
            if (!this.lazyLoad) {
                return Collections.emptyList();
            }
            this.reviewerUpdates = this.approvalsUtil.getReviewerUpdates(this.notes());
        }
        return this.reviewerUpdates;
    }

    public void setReviewerUpdates(List<ReviewerStatusUpdate> reviewerUpdates) {
        this.reviewerUpdates = reviewerUpdates;
    }

    public List<ReviewerStatusUpdate> getReviewerUpdates() {
        return this.reviewerUpdates;
    }

    public Collection<Comment> publishedComments() throws OrmException {
        if (this.publishedComments == null) {
            if (!this.lazyLoad) {
                return Collections.emptyList();
            }
            this.publishedComments = this.commentsUtil.publishedByChange(this.db, this.notes());
        }
        return this.publishedComments;
    }

    public Collection<RobotComment> robotComments() throws OrmException {
        if (this.robotComments == null) {
            if (!this.lazyLoad) {
                return Collections.emptyList();
            }
            this.robotComments = this.commentsUtil.robotCommentsByChange(this.notes());
        }
        return this.robotComments;
    }

    public Integer unresolvedCommentCount() throws OrmException {
        if (this.unresolvedCommentCount == null) {
            if (!this.lazyLoad) {
                return null;
            }
            List comments = Stream.concat(this.publishedComments().stream(), this.robotComments().stream()).collect(Collectors.toList());
            Set nonLeafSet = comments.stream().map(c -> c.parentUuid).collect(Collectors.toSet());
            Long count = comments.stream().filter(c -> c.unresolved && !nonLeafSet.contains(c.key.uuid)).count();
            this.unresolvedCommentCount = count.intValue();
        }
        return this.unresolvedCommentCount;
    }

    public void setUnresolvedCommentCount(Integer count) {
        this.unresolvedCommentCount = count;
    }

    public List<ChangeMessage> messages() throws OrmException {
        if (this.messages == null) {
            if (!this.lazyLoad) {
                return Collections.emptyList();
            }
            this.messages = this.cmUtil.byChange(this.db, this.notes());
        }
        return this.messages;
    }

    public List<SubmitRecord> submitRecords(SubmitRuleOptions options) throws OrmException {
        List<SubmitRecord> records = this.submitRecords.get(options);
        if (records == null) {
            if (!this.lazyLoad) {
                return Collections.emptyList();
            }
            records = new SubmitRuleEvaluator(this).setOptions(options).evaluate();
            this.submitRecords.put(options, records);
        }
        return records;
    }

    @Nullable
    public List<SubmitRecord> getSubmitRecords(SubmitRuleOptions options) {
        return this.submitRecords.get(options);
    }

    public void setSubmitRecords(SubmitRuleOptions options, List<SubmitRecord> records) {
        this.submitRecords.put(options, records);
    }

    public SubmitTypeRecord submitTypeRecord() throws OrmException {
        if (this.submitTypeRecord == null) {
            this.submitTypeRecord = new SubmitRuleEvaluator(this).getSubmitType();
        }
        return this.submitTypeRecord;
    }

    public void setMergeable(Boolean mergeable) {
        this.mergeable = mergeable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean isMergeable() throws OrmException {
        if (this.mergeable != null) return this.mergeable;
        Change c = this.change();
        if (c == null) {
            return null;
        }
        if (c.getStatus() == Change.Status.MERGED) {
            this.mergeable = true;
            return this.mergeable;
        }
        if (c.getStatus() == Change.Status.ABANDONED) {
            return null;
        }
        if (!this.lazyLoad) {
            return null;
        }
        PatchSet ps = this.currentPatchSet();
        try {
            if (ps == null) return null;
            if (!this.changeControl().isOwner() && !this.changeControl().isPatchVisible(ps, this.db)) {
                return null;
            }
        }
        catch (OrmException e) {
            if (!(e.getCause() instanceof NoSuchChangeException)) throw e;
            return null;
        }
        try (Repository repo = this.repoManager.openRepository(this.project());){
            Ref ref = repo.getRefDatabase().exactRef(c.getDest().get());
            SubmitTypeRecord str = this.submitTypeRecord();
            if (!str.isOk()) {
                Boolean bl = false;
                return bl;
            }
            String mergeStrategy = this.mergeUtilFactory.create(this.projectCache.get(this.project())).mergeStrategyName();
            this.mergeable = this.mergeabilityCache.get(ObjectId.fromString(ps.getRevision().get()), ref, str.type, mergeStrategy, c.getDest(), repo);
            return this.mergeable;
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    public Set<Account.Id> editsByUser() throws OrmException {
        return this.editRefs().keySet();
    }

    public Map<Account.Id, Ref> editRefs() throws OrmException {
        if (this.editsByUser == null) {
            if (!this.lazyLoad) {
                return Collections.emptyMap();
            }
            Change c = this.change();
            if (c == null) {
                return Collections.emptyMap();
            }
            this.editsByUser = new HashMap<Account.Id, Ref>();
            Change.Id id = Preconditions.checkNotNull(this.change.getId());
            try (Repository repo = this.repoManager.openRepository(this.project());){
                for (Map.Entry<String, Ref> e : repo.getRefDatabase().getRefs("refs/users/").entrySet()) {
                    if (!id.equals(Change.Id.fromEditRefPart(e.getKey()))) continue;
                    this.editsByUser.put(Account.Id.fromRefPart(e.getKey()), e.getValue());
                }
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
        }
        return this.editsByUser;
    }

    public Set<Account.Id> draftsByUser() throws OrmException {
        return this.draftRefs().keySet();
    }

    public Map<Account.Id, Ref> draftRefs() throws OrmException {
        block6: {
            if (this.draftsByUser != null) break block6;
            if (!this.lazyLoad) {
                return Collections.emptyMap();
            }
            Change c = this.change();
            if (c == null) {
                return Collections.emptyMap();
            }
            this.draftsByUser = new HashMap<Account.Id, Ref>();
            if (this.notesMigration.readChanges()) {
                for (Ref ref : this.commentsUtil.getDraftRefs(this.notes.getChangeId())) {
                    Account.Id account = Account.Id.fromRefSuffix(ref.getName());
                    if (account == null || this.notes().getDraftComments(account, ref).isEmpty()) continue;
                    this.draftsByUser.put(account, ref);
                }
            } else {
                for (Comment sc : this.commentsUtil.draftByChange(this.db, this.notes())) {
                    this.draftsByUser.put(sc.author.getId(), null);
                }
            }
        }
        return this.draftsByUser;
    }

    public Set<Account.Id> reviewedBy() throws OrmException {
        if (this.reviewedBy == null) {
            ReviewedByEvent event;
            if (!this.lazyLoad) {
                return Collections.emptySet();
            }
            Change c = this.change();
            if (c == null) {
                return Collections.emptySet();
            }
            List<ReviewedByEvent> events = new ArrayList();
            for (ChangeMessage msg : this.messages()) {
                if (msg.getAuthor() == null) continue;
                events.add(ReviewedByEvent.create(msg));
            }
            events = Lists.reverse(events);
            this.reviewedBy = new LinkedHashSet<Account.Id>();
            Account.Id owner = c.getOwner();
            Iterator iterator = events.iterator();
            while (iterator.hasNext() && !owner.equals((event = (ReviewedByEvent)iterator.next()).author())) {
                this.reviewedBy.add(event.author());
            }
        }
        return this.reviewedBy;
    }

    public void setReviewedBy(Set<Account.Id> reviewedBy) {
        this.reviewedBy = reviewedBy;
    }

    public Set<String> hashtags() throws OrmException {
        if (this.hashtags == null) {
            if (!this.lazyLoad) {
                return Collections.emptySet();
            }
            this.hashtags = this.notes().getHashtags();
        }
        return this.hashtags;
    }

    public void setHashtags(Set<String> hashtags) {
        this.hashtags = hashtags;
    }

    public ImmutableListMultimap<Account.Id, String> stars() throws OrmException {
        if (this.stars == null) {
            if (!this.lazyLoad) {
                return ImmutableListMultimap.of();
            }
            ImmutableListMultimap.Builder b = ImmutableListMultimap.builder();
            for (Map.Entry e : this.starRefs().entrySet()) {
                b.putAll((Object)((Account.Id)e.getKey()), ((StarredChangesUtil.StarRef)e.getValue()).labels());
            }
            return b.build();
        }
        return this.stars;
    }

    public void setStars(ListMultimap<Account.Id, String> stars) {
        this.stars = ImmutableListMultimap.copyOf(stars);
    }

    public ImmutableMap<Account.Id, StarredChangesUtil.StarRef> starRefs() throws OrmException {
        if (this.starRefs == null) {
            if (!this.lazyLoad) {
                return ImmutableMap.of();
            }
            this.starRefs = Preconditions.checkNotNull(this.starredChangesUtil).byChange(this.legacyId);
        }
        return this.starRefs;
    }

    public Set<String> stars(Account.Id accountId) throws OrmException {
        if (this.starsOf != null && !this.starsOf.accountId().equals(accountId)) {
            this.starsOf = null;
        }
        if (this.starsOf == null) {
            if (this.stars != null) {
                this.starsOf = StarsOf.create(accountId, this.stars.get((Object)accountId));
            } else {
                if (!this.lazyLoad) {
                    return ImmutableSet.of();
                }
                this.starsOf = StarsOf.create(accountId, this.starredChangesUtil.getLabels(accountId, this.legacyId));
            }
        }
        return this.starsOf.stars();
    }

    public String toString() {
        MoreObjects.ToStringHelper h = MoreObjects.toStringHelper(this);
        if (this.change != null) {
            h.addValue(this.change);
        } else {
            h.addValue(this.legacyId);
        }
        return h.toString();
    }

    public ImmutableList<byte[]> getRefStates() {
        return this.refStates;
    }

    public void setRefStates(Iterable<byte[]> refStates) {
        this.refStates = ImmutableList.copyOf(refStates);
    }

    public ImmutableList<byte[]> getRefStatePatterns() {
        return this.refStatePatterns;
    }

    public void setRefStatePatterns(Iterable<byte[]> refStatePatterns) {
        this.refStatePatterns = ImmutableList.copyOf(refStatePatterns);
    }

    @AutoValue
    static abstract class StarsOf {
        StarsOf() {
        }

        private static StarsOf create(Account.Id accountId, Iterable<String> stars) {
            return new AutoValue_ChangeData_StarsOf(accountId, ImmutableSortedSet.copyOf(stars));
        }

        public abstract Account.Id accountId();

        public abstract ImmutableSortedSet<String> stars();
    }

    @AutoValue
    static abstract class ReviewedByEvent {
        ReviewedByEvent() {
        }

        private static ReviewedByEvent create(ChangeMessage msg) {
            return new AutoValue_ChangeData_ReviewedByEvent(msg.getAuthor(), msg.getWrittenOn());
        }

        public abstract Account.Id author();

        public abstract Timestamp ts();
    }

    public static class ChangedLines {
        public final int insertions;
        public final int deletions;

        public ChangedLines(int insertions, int deletions) {
            this.insertions = insertions;
            this.deletions = deletions;
        }
    }

    public static interface Factory {
        public ChangeData create(ReviewDb var1, Project.NameKey var2, Change.Id var3);

        public ChangeData create(ReviewDb var1, Change var2);

        public ChangeData create(ReviewDb var1, ChangeNotes var2);

        public ChangeData create(ReviewDb var1, ChangeControl var2);

        public ChangeData createOnlyWhenNoteDbDisabled(ReviewDb var1, Change.Id var2);
    }
}

