/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Atomics;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandName;
import com.google.gerrit.sshd.CommandProvider;
import com.google.gerrit.sshd.Commands;
import com.google.gerrit.sshd.DispatchCommand;
import com.google.gerrit.sshd.DispatchCommandProvider;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;

public class AliasCommand
extends BaseCommand {
    private final DispatchCommandProvider root;
    private final CurrentUser currentUser;
    private final CommandName command;
    private final AtomicReference<Command> atomicCmd;

    AliasCommand(@CommandName(value="") DispatchCommandProvider root, CurrentUser currentUser, CommandName command) {
        this.root = root;
        this.currentUser = currentUser;
        this.command = command;
        this.atomicCmd = Atomics.newReference();
    }

    @Override
    public void start(Environment env) throws IOException {
        try {
            this.begin(env);
        }
        catch (BaseCommand.UnloggedFailure e) {
            String msg = e.getMessage();
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            this.err.write(msg.getBytes(ENC));
            this.err.flush();
            this.onExit(e.exitCode);
        }
    }

    private void begin(Environment env) throws BaseCommand.UnloggedFailure, IOException {
        Map<String, CommandProvider> map = this.root.getMap();
        for (String name : AliasCommand.chain(this.command)) {
            CommandProvider p = (CommandProvider)map.get(name);
            if (p == null) {
                throw this.die(this.getName() + ": not found");
            }
            Command cmd = p.getProvider().get();
            if (!(cmd instanceof DispatchCommand)) {
                throw this.die(this.getName() + ": not found");
            }
            map = ((DispatchCommand)cmd).getMap();
        }
        CommandProvider p = (CommandProvider)map.get(this.command.value());
        if (p == null) {
            throw this.die(this.getName() + ": not found");
        }
        Command cmd = p.getProvider().get();
        this.checkRequiresCapability(cmd);
        if (cmd instanceof BaseCommand) {
            BaseCommand bc = (BaseCommand)cmd;
            bc.setName(this.getName());
            bc.setArguments(this.getArguments());
        }
        this.provideStateTo(cmd);
        this.atomicCmd.set(cmd);
        cmd.start(env);
    }

    @Override
    public void destroy() {
        Command cmd = this.atomicCmd.getAndSet(null);
        if (cmd != null) {
            try {
                cmd.destroy();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
    }

    private void checkRequiresCapability(Command cmd) throws BaseCommand.UnloggedFailure {
        CapabilityControl ctl;
        RequiresCapability rc = cmd.getClass().getAnnotation(RequiresCapability.class);
        if (rc != null && !(ctl = this.currentUser.getCapabilities()).canPerform(rc.value()) && !ctl.canAdministrateServer()) {
            String msg = String.format("fatal: %s does not have \"%s\" capability.", this.currentUser.getUserName(), rc.value());
            throw new BaseCommand.UnloggedFailure(0x40000003, msg);
        }
    }

    private static LinkedList<String> chain(CommandName command) {
        LinkedList<String> chain = new LinkedList<String>();
        while (command != null) {
            chain.addFirst(command.value());
            command = Commands.parentOf(command);
        }
        chain.removeLast();
        return chain;
    }
}

