/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.Sets;
import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.plugins.PluginInstallException;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.List;
import org.kohsuke.args4j.Argument;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="enable", description="Enable plugins", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
final class PluginEnableCommand
extends SshCommand {
    @Argument(index=0, metaVar="NAME", required=true, usage="plugin(s) to enable")
    List<String> names;
    @Inject
    private PluginLoader loader;

    PluginEnableCommand() {
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        if (!this.loader.isRemoteAdminEnabled()) {
            throw this.die("remote plugin administration is disabled");
        }
        if (this.names != null && !this.names.isEmpty()) {
            try {
                this.loader.enablePlugins(Sets.newHashSet(this.names));
            }
            catch (PluginInstallException e) {
                e.printStackTrace(this.stderr);
                throw this.die("plugin failed to enable");
            }
        }
    }
}

