/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.server.query.change.OutputStreamQuery;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="query", description="Query the change database")
class Query
extends SshCommand {
    @Inject
    private OutputStreamQuery processor;
    @Argument(index=0, required=true, multiValued=true, metaVar="QUERY", usage="Query to execute")
    private List<String> query;

    Query() {
    }

    @Option(name="--format", metaVar="FMT", usage="Output display format")
    void setFormat(OutputStreamQuery.OutputFormat format) {
        this.processor.setOutput(this.out, format);
    }

    @Option(name="--current-patch-set", usage="Include information about current patch set")
    void setCurrentPatchSet(boolean on) {
        this.processor.setIncludeCurrentPatchSet(on);
    }

    @Option(name="--patch-sets", usage="Include information about all patch sets")
    void setPatchSets(boolean on) {
        this.processor.setIncludePatchSets(on);
    }

    @Option(name="--all-approvals", usage="Include information about all patch sets and approvals")
    void setApprovals(boolean on) {
        if (on) {
            this.processor.setIncludePatchSets(on);
        }
        this.processor.setIncludeApprovals(on);
    }

    @Option(name="--comments", usage="Include patch set and inline comments")
    void setComments(boolean on) {
        this.processor.setIncludeComments(on);
    }

    @Option(name="--files", usage="Include file list on patch sets")
    void setFiles(boolean on) {
        this.processor.setIncludeFiles(on);
    }

    @Option(name="--commit-message", usage="Include the full commit message for a change")
    void setCommitMessage(boolean on) {
        this.processor.setIncludeCommitMessage(on);
    }

    @Option(name="--dependencies", usage="Include depends-on and needed-by information")
    void setDependencies(boolean on) {
        this.processor.setIncludeDependencies(on);
    }

    @Option(name="--all-reviewers", usage="Include all reviewers")
    void setAllReviewers(boolean on) {
        this.processor.setIncludeAllReviewers(on);
    }

    @Option(name="--submit-records", usage="Include submit and label status")
    void setSubmitRecords(boolean on) {
        this.processor.setIncludeSubmitRecords(on);
    }

    @Option(name="--start", aliases={"-S"}, usage="Number of changes to skip")
    void setStart(int start) {
        this.processor.setStart(start);
    }

    @Override
    protected void run() throws Exception {
        this.processor.query(Query.join(this.query, " "));
    }

    @Override
    protected void parseCommandLine() throws BaseCommand.UnloggedFailure {
        this.processor.setOutput(this.out, OutputStreamQuery.OutputFormat.TEXT);
        super.parseCommandLine();
        if (this.processor.getIncludeFiles() && !this.processor.getIncludePatchSets() && !this.processor.getIncludeCurrentPatchSet()) {
            throw this.die("--files option needs --patch-sets or --current-patch-set");
        }
    }

    private static String join(List<String> list, String sep) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                r.append(sep);
            }
            r.append(list.get(i));
        }
        return r.toString();
    }
}

