/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.SetHead;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@CommandMetaData(name="set-head", description="Change HEAD reference for a project")
public class SetHeadCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="NAME", usage="name of the project")
    private ProjectControl project;
    @Option(name="--new-head", required=true, metaVar="REF", usage="new HEAD reference")
    private String newHead;
    private final SetHead setHead;

    @Inject
    SetHeadCommand(SetHead setHead) {
        this.setHead = setHead;
    }

    @Override
    protected void run() throws Exception {
        SetHead.Input input = new SetHead.Input();
        input.ref = this.newHead;
        try {
            this.setHead.apply(new ProjectResource(this.project), input);
        }
        catch (UnprocessableEntityException e) {
            throw this.die(e);
        }
    }
}

