/*
 * Decompiled with CFR 0.152.
 */
package com.google.gitiles.blame;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;

public class Region
implements Serializable,
Comparable<Region> {
    private static final long serialVersionUID = 1L;
    private final String sourcePath;
    private final ObjectId sourceCommit;
    private final PersonIdent sourceAuthor;
    private final int count;
    private transient int start;

    public Region(String string, ObjectId objectId, PersonIdent personIdent, int n, int n2) {
        Preconditions.checkArgument(string != null && objectId != null && personIdent != null || string == null && objectId == null && personIdent == null, "expected all null or none: %s, %s, %s", (Object)string, (Object)objectId, (Object)personIdent);
        this.sourcePath = string;
        this.sourceCommit = objectId;
        this.sourceAuthor = personIdent;
        this.start = n;
        this.count = n2 - n;
    }

    void setStart(int n) {
        this.start = n;
    }

    int getStart() {
        return this.start;
    }

    int getEnd() {
        return this.start + this.count;
    }

    public int getCount() {
        return this.count;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public ObjectId getSourceCommit() {
        return this.sourceCommit;
    }

    public PersonIdent getSourceAuthor() {
        return this.sourceAuthor;
    }

    @Override
    public int compareTo(Region region) {
        return this.start - region.start;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sourceCommit != null) {
            stringBuilder.append(this.sourceCommit.name(), 0, 7).append(' ').append(this.sourceAuthor.toExternalString()).append(" (").append(this.sourcePath).append(')');
        } else {
            stringBuilder.append("<unblamed region>");
        }
        stringBuilder.append(' ').append("start=").append(this.start).append(", count=").append(this.count);
        return stringBuilder.toString();
    }
}

