/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;
import java.util.List;

public final class ExprRootNode
extends AbstractParentExprNode {
    public static List<ExprNode> unwrap(Iterable<ExprRootNode> exprs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ExprRootNode expr : exprs) {
            builder.add(expr.getRoot());
        }
        return builder.build();
    }

    public static List<ExprRootNode> wrap(Iterable<? extends ExprNode> exprs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ExprNode exprNode : exprs) {
            builder.add(new ExprRootNode(exprNode));
        }
        return builder.build();
    }

    public ExprRootNode(ExprNode child) {
        super(child.getSourceLocation());
        Preconditions.checkArgument(!(child instanceof ExprRootNode));
        this.addChild(child);
    }

    private ExprRootNode(ExprRootNode orig, CopyState copyState) {
        super(orig, copyState);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.EXPR_ROOT_NODE;
    }

    public ExprNode getRoot() {
        return this.getChild(0);
    }

    @Override
    public ExprNode getChild(int index) {
        Preconditions.checkArgument(index == 0);
        return super.getChild(0);
    }

    @Override
    public String toSourceString() {
        return this.getRoot().toSourceString();
    }

    @Override
    public ExprRootNode copy(CopyState copyState) {
        return new ExprRootNode(this, copyState);
    }
}

