/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.List;
import javax.annotation.Nullable;

final class RewriteGenderMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind GENDER_AND_SELECT_NOT_ALLOWED = SoyErrorKind.of("Cannot mix ''genders'' attribute with ''select'' command in the same message.");
    private static final SoyErrorKind MORE_THAN_TWO_GENDER_EXPRS = SoyErrorKind.of("In a msg with ''plural'', the ''genders'' attribute can contain at most 2 expressions (otherwise, combinatorial explosion would cause a gigantic generated message).");
    public static final String FALLBACK_BASE_SELECT_VAR_NAME = "GENDER";
    private final ErrorReporter errorReporter;
    private IdGenerator nodeIdGen;

    public RewriteGenderMsgsVisitor(IdGenerator nodeIdGen, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.nodeIdGen = Preconditions.checkNotNull(nodeIdGen);
    }

    @Override
    protected void visitMsgNode(MsgNode msg) {
        SoyNode.StandaloneNode first;
        List<ExprRootNode> genderExprs = msg.getAndRemoveGenderExprs();
        if (genderExprs == null) {
            return;
        }
        SoyNode.StandaloneNode standaloneNode = first = msg.numChildren() > 0 ? (SoyNode.StandaloneNode)msg.getChild(0) : null;
        if (first instanceof MsgSelectNode) {
            this.errorReporter.report(first.getSourceLocation(), GENDER_AND_SELECT_NOT_ALLOWED, new Object[0]);
        }
        if (first instanceof MsgPluralNode && genderExprs.size() > 2) {
            this.errorReporter.report(msg.getSourceLocation(), MORE_THAN_TWO_GENDER_EXPRS, new Object[0]);
        }
        genderExprs = Lists.reverse(genderExprs);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        List<String> baseSelectVarNames = MsgSubstUnitBaseVarNameUtils.genNoncollidingBaseNamesForExprs(ExprRootNode.unwrap(genderExprs), FALLBACK_BASE_SELECT_VAR_NAME, this.errorReporter);
        if (this.errorReporter.errorsSince(checkpoint)) {
            return;
        }
        for (int i = 0; i < genderExprs.size(); ++i) {
            ExprRootNode genderExpr = genderExprs.get(i);
            String baseSelectVarName = baseSelectVarNames.get(i);
            if (MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(genderExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME).equals(baseSelectVarName) && MsgSubstUnitBaseVarNameUtils.genShortestBaseNameForExpr(genderExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME).equals(baseSelectVarName)) {
                baseSelectVarName = null;
            }
            this.splitMsgForGender(msg, genderExpr, baseSelectVarName);
        }
    }

    private void splitMsgForGender(MsgNode msg, ExprRootNode genderExpr, @Nullable String baseSelectVarName) {
        ImmutableList origChildren = ImmutableList.copyOf(msg.getChildren());
        msg.clearChildren();
        SoyParsingContext context = SoyParsingContext.empty(this.errorReporter, "fake.namespace");
        MsgSelectCaseNode femaleCase = new MsgSelectCaseNode.Builder(this.nodeIdGen.genId(), "'female'", msg.getSourceLocation()).build(context);
        femaleCase.addChildren(SoyTreeUtils.cloneListWithNewIds(origChildren, this.nodeIdGen));
        MsgSelectCaseNode maleCase = new MsgSelectCaseNode.Builder(this.nodeIdGen.genId(), "'male'", msg.getSourceLocation()).build(context);
        maleCase.addChildren(SoyTreeUtils.cloneListWithNewIds(origChildren, this.nodeIdGen));
        MsgSelectDefaultNode defaultCase = new MsgSelectDefaultNode(this.nodeIdGen.genId(), msg.getSourceLocation());
        defaultCase.addChildren(SoyTreeUtils.cloneListWithNewIds(origChildren, this.nodeIdGen));
        MsgSelectNode selectNode = new MsgSelectNode(this.nodeIdGen.genId(), msg.getSourceLocation(), genderExpr, baseSelectVarName);
        selectNode.addChild(femaleCase);
        selectNode.addChild(maleCase);
        selectNode.addChild(defaultCase);
        msg.addChild(selectNode);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }
}

