/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.IsCalleeInFileVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.soytree.AbstractReturningSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import java.util.LinkedHashMap;
import javax.inject.Inject;

final class GenPyCallExprVisitor
extends AbstractReturningSoyNodeVisitor<PyExpr> {
    private final ImmutableMap<String, SoyPySrcPrintDirective> soyPySrcDirectivesMap;
    private final IsComputableAsPyExprVisitor isComputableAsPyExprVisitor;
    private final IsCalleeInFileVisitor isCalleeInFileVisitor;
    private final GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory;
    private LocalVariableStack localVarStack;
    private ErrorReporter errorReporter;

    @Inject
    GenPyCallExprVisitor(ImmutableMap<String, SoyPySrcPrintDirective> soyPySrcDirectivesMap, IsComputableAsPyExprVisitor isComputableAsPyExprVisitor, IsCalleeInFileVisitor isCalleeInFileVisitor, GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory) {
        this.soyPySrcDirectivesMap = soyPySrcDirectivesMap;
        this.isComputableAsPyExprVisitor = isComputableAsPyExprVisitor;
        this.isCalleeInFileVisitor = isCalleeInFileVisitor;
        this.genPyExprsVisitorFactory = genPyExprsVisitorFactory;
    }

    PyExpr exec(CallNode callNode, LocalVariableStack localVarStack, ErrorReporter errorReporter) {
        this.localVarStack = localVarStack;
        this.errorReporter = errorReporter;
        PyExpr callExpr = (PyExpr)this.visit(callNode);
        this.localVarStack = null;
        this.errorReporter = null;
        return callExpr;
    }

    @Override
    protected PyExpr visitCallBasicNode(CallBasicNode node) {
        String calleeExprText;
        String calleeName = node.getCalleeName();
        if (this.isCalleeInFileVisitor.visitCallBasicNode(node).booleanValue()) {
            calleeExprText = calleeName.substring(calleeName.lastIndexOf(46) + 1);
        } else {
            int secondToLastDotIndex = calleeName.lastIndexOf(46, calleeName.lastIndexOf(46) - 1);
            calleeExprText = calleeName.substring(secondToLastDotIndex + 1);
        }
        String callExprText = calleeExprText + "(" + this.genObjToPass(node) + ", ijData)";
        return this.escapeCall(callExprText, node.getEscapingDirectiveNames());
    }

    @Override
    protected PyExpr visitCallDelegateNode(CallDelegateNode node) {
        PyExpr variantPyExpr;
        ExprRootNode variantSoyExpr = node.getDelCalleeVariantExpr();
        if (variantSoyExpr == null) {
            variantPyExpr = new PyStringExpr("''");
        } else {
            TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarStack, this.errorReporter);
            variantPyExpr = (PyExpr)translator.exec(variantSoyExpr);
        }
        String calleeExprText = new PyFunctionExprBuilder("runtime.get_delegate_fn").addArg(node.getDelCalleeName()).addArg(variantPyExpr).addArg(node.allowsEmptyDefault()).build();
        String callExprText = calleeExprText + "(" + this.genObjToPass(node) + ", ijData)";
        return this.escapeCall(callExprText, node.getEscapingDirectiveNames());
    }

    public String genObjToPass(CallNode callNode) {
        TranslateToPyExprVisitor translator = new TranslateToPyExprVisitor(this.localVarStack, this.errorReporter);
        String dataToPass = callNode.dataAttribute().isPassingAllData() ? "data" : (callNode.dataAttribute().isPassingData() ? ((PyExpr)translator.exec(callNode.dataAttribute().dataExpr())).getText() : "{}");
        if (callNode.numChildren() == 0) {
            return dataToPass;
        }
        LinkedHashMap<PyExpr, PyExpr> additionalParams = new LinkedHashMap<PyExpr, PyExpr>();
        for (CallParamNode child : callNode.getChildren()) {
            PyExpr valuePyExpr;
            PyStringExpr key = new PyStringExpr("'" + child.getKey() + "'");
            if (child instanceof CallParamValueNode) {
                CallParamValueNode cpvn = (CallParamValueNode)child;
                additionalParams.put(key, (PyExpr)translator.exec(cpvn.getValueExprUnion().getExpr()));
                continue;
            }
            CallParamContentNode cpcn = (CallParamContentNode)child;
            if (((Boolean)this.isComputableAsPyExprVisitor.exec(cpcn)).booleanValue()) {
                valuePyExpr = PyExprUtils.concatPyExprs(this.genPyExprsVisitorFactory.create(this.localVarStack, this.errorReporter).exec(cpcn));
            } else {
                String paramExpr = "param" + cpcn.getId();
                valuePyExpr = new PyListExpr(paramExpr, Integer.MAX_VALUE);
            }
            valuePyExpr = PyExprUtils.wrapAsSanitizedContent(cpcn.getContentKind(), valuePyExpr.toPyString());
            additionalParams.put(key, valuePyExpr);
        }
        PyExpr additionalParamsExpr = PyExprUtils.convertMapToPyExpr(additionalParams);
        if (callNode.dataAttribute().isPassingData()) {
            dataToPass = "dict(" + dataToPass + ")";
            return "runtime.merge_into_dict(" + dataToPass + ", " + additionalParamsExpr.getText() + ")";
        }
        return additionalParamsExpr.getText();
    }

    private PyExpr escapeCall(String callExpr, ImmutableList<String> directiveNames) {
        PyExpr escapedExpr = new PyExpr(callExpr, Integer.MAX_VALUE);
        if (directiveNames.isEmpty()) {
            return escapedExpr;
        }
        for (String directiveName : directiveNames) {
            SoyPySrcPrintDirective directive = this.soyPySrcDirectivesMap.get(directiveName);
            Preconditions.checkNotNull(directive, "Autoescaping produced a bogus directive: %s", (Object)directiveName);
            escapedExpr = directive.applyForPySrc(escapedExpr, ImmutableList.of());
        }
        return escapedExpr;
    }
}

