/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.restricted;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public final class TagWhitelist {
    private final ImmutableSet<String> safeTagNames;
    private static final Pattern VALID_TAG_NAME = Pattern.compile("^[A-Za-z][A-Za-z0-9]*(?:-[A-Za-z][A-Za-z0-9]*)*\\z");
    public static final TagWhitelist FORMATTING = new TagWhitelist("b", "br", "em", "i", "s", "sub", "sup", "u");

    TagWhitelist(Collection<String> tagNames) {
        this.safeTagNames = ImmutableSet.copyOf(tagNames);
        assert (TagWhitelist.requireLowerCaseTagNames(this.safeTagNames));
    }

    TagWhitelist(String ... tagNames) {
        this(Arrays.asList(tagNames));
    }

    public TagWhitelist withOptionalSafeTags(Collection<? extends OptionalSafeTag> optionalSafeTags) {
        if (optionalSafeTags.isEmpty()) {
            return this;
        }
        ImmutableSet<String> optionalSafeTagNames = FluentIterable.from(optionalSafeTags).transform(OptionalSafeTag.TO_TAG_NAME).toSet();
        return new TagWhitelist(Sets.union(this.safeTagNames, optionalSafeTagNames));
    }

    public boolean isSafeTag(String tagName) {
        return this.safeTagNames.contains(tagName);
    }

    public Set<String> asSet() {
        return this.safeTagNames;
    }

    private static boolean requireLowerCaseTagNames(Iterable<String> strs) {
        for (String str : strs) {
            assert (str.equals(str.toLowerCase(Locale.ENGLISH)) && VALID_TAG_NAME.matcher(str).matches()) : str;
        }
        return true;
    }

    public static enum OptionalSafeTag {
        LI("li"),
        OL("ol"),
        SPAN("span"),
        UL("ul");

        private final String tagName;
        public static final Function<String, OptionalSafeTag> FROM_TAG_NAME;
        public static final Function<OptionalSafeTag, String> TO_TAG_NAME;
        private static final ImmutableMap<String, OptionalSafeTag> OPTIONAL_SAFE_TAGS_BY_TAG_NAME;

        private OptionalSafeTag(String tagName) {
            this.tagName = tagName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public static OptionalSafeTag fromTagName(String tagName) {
            OptionalSafeTag tag = OPTIONAL_SAFE_TAGS_BY_TAG_NAME.get(tagName);
            if (tag == null) {
                throw new IllegalArgumentException(String.format("%s is not a valid optional safe tag.", tagName));
            }
            return tag;
        }

        static {
            FROM_TAG_NAME = new Function<String, OptionalSafeTag>(){

                @Override
                public OptionalSafeTag apply(String tagName) {
                    return OptionalSafeTag.fromTagName(tagName);
                }
            };
            TO_TAG_NAME = new Function<OptionalSafeTag, String>(){

                @Override
                public String apply(OptionalSafeTag tag) {
                    return tag.getTagName();
                }
            };
            OPTIONAL_SAFE_TAGS_BY_TAG_NAME = Maps.uniqueIndex(EnumSet.allOf(OptionalSafeTag.class), TO_TAG_NAME);
        }
    }
}

