/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;

final class SourceItemInfo<T> {
    private final T parsedContent;
    private final SourceLocation location;

    SourceItemInfo(T parsedContent, SourceItemInfo<?> begin, SourceItemInfo<?> end) {
        this(begin.location.getFilePath(), parsedContent, begin.location.getBeginLine(), begin.location.getBeginColumn(), end.location.getEndLine(), end.location.getEndColumn());
        Preconditions.checkArgument(begin.location.getFileName().equals(end.location.getFileName()));
    }

    SourceItemInfo(String filePath, T parsedContent, int lineNum, int columnNum, int lineNumEnd, int columnNumEnd) {
        this.location = new SourceLocation(filePath, lineNum, columnNum, lineNumEnd, columnNumEnd);
        this.parsedContent = parsedContent;
    }

    SourceItemInfo(T parsedContent, SourceLocation location) {
        this.location = location;
        this.parsedContent = parsedContent;
    }

    T parsedContent() {
        return this.parsedContent;
    }

    SourceLocation srcLocation() {
        return this.location;
    }
}

