/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;

public final class AliasDeclaration {
    private static final SoyErrorKind INVALID_ALIAS_NAME = SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.");
    private final String namespace;
    private final String alias;
    private final SourceLocation location;

    public AliasDeclaration(String namespace, String alias, ErrorReporter errorReporter, SourceLocation location) {
        Preconditions.checkArgument(BaseUtils.isDottedIdentifier(namespace));
        Preconditions.checkArgument(BaseUtils.isDottedIdentifier(alias));
        this.namespace = namespace;
        this.alias = alias;
        this.location = location;
        if (!BaseUtils.isIdentifier(alias)) {
            errorReporter.report(location, INVALID_ALIAS_NAME, alias);
        }
    }

    public AliasDeclaration(String namespace, ErrorReporter errorReporter, SourceLocation location) {
        this(namespace, BaseUtils.extractPartAfterLastDot(namespace), errorReporter, location);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getAlias() {
        return this.alias;
    }

    public SourceLocation getLocation() {
        return this.location;
    }
}

