/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.Rule;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.transform.CacheArguments;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class CachingGenerator
implements RuleMethodProcessor {
    private ParserClassNode classNode;
    private RuleMethod method;
    private InsnList instructions;
    private AbstractInsnNode current;
    private String cacheFieldName;

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        return method.hasCachedAnnotation();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkState(!method.isSuperMethod());
        this.classNode = classNode;
        this.method = method;
        this.instructions = method.instructions;
        this.current = this.instructions.getFirst();
        this.generateCacheHitReturn();
        this.generateStoreNewProxyMatcher();
        this.seekToReturnInstruction();
        this.generateArmProxyMatcher();
        this.generateStoreInCache();
    }

    private void generateCacheHitReturn() {
        this.generateGetFromCache();
        this.insert(new InsnNode(89));
        LabelNode cacheMissLabel = new LabelNode();
        this.insert(new JumpInsnNode(198, cacheMissLabel));
        this.insert(new InsnNode(176));
        this.insert(cacheMissLabel);
        this.insert(new InsnNode(87));
    }

    private void generateGetFromCache() {
        Type[] paramTypes = Type.getArgumentTypes(this.method.desc);
        this.cacheFieldName = this.findUnusedCacheFieldName();
        String cacheFieldDesc = paramTypes.length == 0 ? CodegenUtils.ci(Rule.class) : CodegenUtils.ci(HashMap.class);
        FieldNode field = new FieldNode(2, this.cacheFieldName, cacheFieldDesc, null, null);
        FieldInsnNode insn = new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, cacheFieldDesc);
        this.classNode.fields.add(field);
        this.insert(new VarInsnNode(25, 0));
        this.insert(insn);
        if (paramTypes.length == 0) {
            return;
        }
        this.insert(new InsnNode(89));
        LabelNode alreadyInitialized = new LabelNode();
        this.insert(new JumpInsnNode(199, alreadyInitialized));
        this.insert(new InsnNode(87));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new TypeInsnNode(187, CodegenUtils.p(HashMap.class)));
        this.insert(new InsnNode(90));
        this.insert(new InsnNode(89));
        this.insert(new MethodInsnNode(183, CodegenUtils.p(HashMap.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), false));
        this.insert(new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, cacheFieldDesc));
        this.insert(alreadyInitialized);
        if (paramTypes.length > 1 || paramTypes[0].getSort() == 9) {
            this.insert(new TypeInsnNode(187, CodegenUtils.p(CacheArguments.class)));
            this.insert(new InsnNode(89));
            this.generatePushNewParameterObjectArray(paramTypes);
            this.insert(new MethodInsnNode(183, CodegenUtils.p(CacheArguments.class), "<init>", CodegenUtils.sig(Void.TYPE, Object[].class), false));
        } else {
            this.generatePushParameterAsObject(paramTypes, 0);
        }
        this.insert(new InsnNode(89));
        this.insert(new VarInsnNode(58, this.method.maxLocals));
        this.insert(new MethodInsnNode(182, CodegenUtils.p(HashMap.class), "get", CodegenUtils.sig(Object.class, Object.class), false));
        this.insert(new TypeInsnNode(192, CodegenUtils.p(Rule.class)));
    }

    private String findUnusedCacheFieldName() {
        String name = "cache$" + this.method.name;
        int i = 2;
        while (this.hasField(name)) {
            name = "cache$" + this.method.name + i++;
        }
        return name;
    }

    public boolean hasField(String fieldName) {
        for (FieldNode field : this.classNode.fields) {
            if (!fieldName.equals(field.name)) continue;
            return true;
        }
        return false;
    }

    private void generatePushNewParameterObjectArray(Type[] paramTypes) {
        this.insert(new IntInsnNode(16, paramTypes.length));
        this.insert(new TypeInsnNode(189, CodegenUtils.p(Object.class)));
        for (int i = 0; i < paramTypes.length; ++i) {
            this.insert(new InsnNode(89));
            this.insert(new IntInsnNode(16, i));
            this.generatePushParameterAsObject(paramTypes, i);
            this.insert(new InsnNode(83));
        }
    }

    private void generatePushParameterAsObject(Type[] paramTypes, int parameterNr) {
        switch (paramTypes[parameterNr++].getSort()) {
            case 1: {
                this.insert(new VarInsnNode(21, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Boolean.class), "valueOf", CodegenUtils.sig(Boolean.class, Boolean.TYPE), false));
                return;
            }
            case 2: {
                this.insert(new VarInsnNode(21, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Character.class), "valueOf", CodegenUtils.sig(Character.class, Character.TYPE), false));
                return;
            }
            case 3: {
                this.insert(new VarInsnNode(21, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Byte.class), "valueOf", CodegenUtils.sig(Byte.class, Byte.TYPE), false));
                return;
            }
            case 4: {
                this.insert(new VarInsnNode(21, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Short.class), "valueOf", CodegenUtils.sig(Short.class, Short.TYPE), false));
                return;
            }
            case 5: {
                this.insert(new VarInsnNode(21, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Integer.class), "valueOf", CodegenUtils.sig(Integer.class, Integer.TYPE), false));
                return;
            }
            case 6: {
                this.insert(new VarInsnNode(23, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Float.class), "valueOf", CodegenUtils.sig(Float.class, Float.TYPE), false));
                return;
            }
            case 7: {
                this.insert(new VarInsnNode(22, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Long.class), "valueOf", CodegenUtils.sig(Long.class, Long.TYPE), false));
                return;
            }
            case 8: {
                this.insert(new VarInsnNode(24, parameterNr));
                this.insert(new MethodInsnNode(184, CodegenUtils.p(Double.class), "valueOf", CodegenUtils.sig(Double.class, Double.TYPE), false));
                return;
            }
            case 9: 
            case 10: {
                this.insert(new VarInsnNode(25, parameterNr));
                return;
            }
        }
        throw new IllegalStateException();
    }

    private void generateStoreNewProxyMatcher() {
        this.insert(new TypeInsnNode(187, CodegenUtils.p(ProxyMatcher.class)));
        this.insert(new InsnNode(89));
        this.insert(new MethodInsnNode(183, CodegenUtils.p(ProxyMatcher.class), "<init>", CodegenUtils.sig(Void.TYPE, new Class[0]), false));
        this.generateStoreInCache();
    }

    private void seekToReturnInstruction() {
        while (this.current.getOpcode() != 176) {
            this.current = this.current.getNext();
        }
    }

    private void generateArmProxyMatcher() {
        this.insert(new InsnNode(90));
        this.insert(new TypeInsnNode(192, CodegenUtils.p(Matcher.class)));
        this.insert(new MethodInsnNode(182, CodegenUtils.p(ProxyMatcher.class), "arm", CodegenUtils.sig(Void.TYPE, Matcher.class), false));
    }

    private void generateStoreInCache() {
        Type[] paramTypes = Type.getArgumentTypes(this.method.desc);
        this.insert(new InsnNode(89));
        if (paramTypes.length == 0) {
            this.insert(new VarInsnNode(25, 0));
            this.insert(new InsnNode(95));
            this.insert(new FieldInsnNode(181, this.classNode.name, this.cacheFieldName, CodegenUtils.ci(Rule.class)));
            return;
        }
        this.insert(new VarInsnNode(25, this.method.maxLocals));
        this.insert(new InsnNode(95));
        this.insert(new VarInsnNode(25, 0));
        this.insert(new FieldInsnNode(180, this.classNode.name, this.cacheFieldName, CodegenUtils.ci(HashMap.class)));
        this.insert(new InsnNode(91));
        this.insert(new InsnNode(87));
        this.insert(new MethodInsnNode(182, CodegenUtils.p(HashMap.class), "put", CodegenUtils.sig(Object.class, Object.class, Object.class), false));
        this.insert(new InsnNode(87));
    }

    private void insert(AbstractInsnNode instruction) {
        this.instructions.insertBefore(this.current, instruction);
    }
}

