/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.gerrit.extensions.restapi.RawInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;

@GwtIncompatible(value="Unemulated classes in java.io and javax.servlet")
public class RawInputUtil {
    public static RawInput create(String content) {
        return RawInputUtil.create(content.getBytes(StandardCharsets.UTF_8));
    }

    public static RawInput create(final byte[] bytes, final String contentType) {
        Preconditions.checkNotNull(bytes);
        Preconditions.checkArgument(bytes.length > 0);
        return new RawInput(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            public long getContentLength() {
                return bytes.length;
            }
        };
    }

    public static RawInput create(byte[] bytes) {
        return RawInputUtil.create(bytes, "application/octet-stream");
    }

    public static RawInput create(final HttpServletRequest req) {
        return new RawInput(){

            @Override
            public String getContentType() {
                return req.getContentType();
            }

            @Override
            public long getContentLength() {
                return req.getContentLength();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return req.getInputStream();
            }
        };
    }
}

