/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.extensions.registration.PrivateInternals_DynamicTypes;
import com.google.gerrit.httpd.GitOverHttpServlet;
import com.google.gerrit.httpd.HttpRemotePeerProvider;
import com.google.gerrit.httpd.HttpRequestContext;
import com.google.gerrit.httpd.ProxyProperties;
import com.google.gerrit.httpd.ProxyPropertiesProvider;
import com.google.gerrit.httpd.UniversalWebLoginFilter;
import com.google.gerrit.httpd.UrlModule;
import com.google.gerrit.httpd.auth.become.BecomeAnyAccountModule;
import com.google.gerrit.httpd.auth.container.HttpAuthModule;
import com.google.gerrit.httpd.auth.container.HttpsClientSslCertModule;
import com.google.gerrit.httpd.auth.ldap.LdapAuthModule;
import com.google.gerrit.httpd.gitweb.GitwebModule;
import com.google.gerrit.httpd.rpc.UiRpcModule;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.RemotePeer;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.GerritOptions;
import com.google.gerrit.server.config.GerritRequestModule;
import com.google.gerrit.server.config.GitwebCgiConfig;
import com.google.gerrit.server.git.AsyncReceiveCommits;
import com.google.gerrit.server.util.GuiceRequestScopePropagator;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.servlet.RequestScoped;
import java.net.SocketAddress;

public class WebModule
extends LifecycleModule {
    private final AuthConfig authConfig;
    private final GitwebCgiConfig gitwebCgiConfig;
    private final GerritOptions options;

    @Inject
    WebModule(AuthConfig authConfig, GerritOptions options, GitwebCgiConfig gitwebCgiConfig) {
        this.authConfig = authConfig;
        this.options = options;
        this.gitwebCgiConfig = gitwebCgiConfig;
    }

    @Override
    protected void configure() {
        this.bind(RequestScopePropagator.class).to(GuiceRequestScopePropagator.class);
        this.bind(HttpRequestContext.class);
        this.installAuthModule();
        if (this.options.enableMasterFeatures()) {
            this.install(new UrlModule(this.options, this.authConfig));
            this.install(new UiRpcModule());
        }
        this.install(new GerritRequestModule());
        this.install(new GitOverHttpServlet.Module(this.options.enableMasterFeatures()));
        if (this.gitwebCgiConfig.getGitwebCgi() != null) {
            this.install(new GitwebModule());
        }
        this.install(new AsyncReceiveCommits.Module());
        this.bind(SocketAddress.class).annotatedWith(RemotePeer.class).toProvider(HttpRemotePeerProvider.class).in(RequestScoped.class);
        this.bind(ProxyProperties.class).toProvider(ProxyPropertiesProvider.class);
        this.listener().toInstance(PrivateInternals_DynamicTypes.registerInParentInjectors());
        this.install(UniversalWebLoginFilter.module());
    }

    private void installAuthModule() {
        switch (this.authConfig.getAuthType()) {
            case HTTP: 
            case HTTP_LDAP: {
                this.install(new HttpAuthModule(this.authConfig));
                break;
            }
            case CLIENT_SSL_CERT_LDAP: {
                this.install(new HttpsClientSslCertModule());
                break;
            }
            case LDAP: 
            case LDAP_BIND: {
                this.install(new LdapAuthModule());
                break;
            }
            case DEVELOPMENT_BECOME_ANY_ACCOUNT: {
                this.install(new BecomeAnyAccountModule());
                break;
            }
            case OAUTH: 
            case OPENID: 
            case OPENID_SSO: 
            case CUSTOM_EXTENSION: {
                break;
            }
            default: {
                throw new ProvisionException("Unsupported loginType: " + (Object)((Object)this.authConfig.getAuthType()));
            }
        }
    }
}

