/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc;

import com.google.gerrit.common.data.SshHostKey;
import com.google.gerrit.common.data.SystemInfoService;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gwtjsonrpc.common.AsyncCallback;
import com.google.gwtjsonrpc.common.VoidResult;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.JSch;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SystemInfoServiceImpl
implements SystemInfoService {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoServiceImpl.class);
    private static final JSch JSCH = new JSch();
    private final List<HostKey> hostKeys;
    private final Provider<HttpServletRequest> httpRequest;

    @Inject
    SystemInfoServiceImpl(SshInfo daemon, Provider<HttpServletRequest> hsr) {
        this.hostKeys = daemon.getHostKeys();
        this.httpRequest = hsr;
    }

    @Override
    public void daemonHostKeys(AsyncCallback<List<SshHostKey>> callback) {
        ArrayList<SshHostKey> r = new ArrayList<SshHostKey>(this.hostKeys.size());
        for (HostKey hk : this.hostKeys) {
            String host = hk.getHost();
            if (host.startsWith("*:")) {
                String port = host.substring(2);
                host = "[" + this.httpRequest.get().getServerName() + "]:" + port;
            }
            String fp = hk.getFingerPrint(JSCH);
            r.add(new SshHostKey(host, hk.getType() + " " + hk.getKey(), fp));
        }
        callback.onSuccess(r);
    }

    @Override
    public void clientError(String message, AsyncCallback<VoidResult> callback) {
        HttpServletRequest r = this.httpRequest.get();
        String ua = r.getHeader("User-Agent");
        message = message.replaceAll("\n", "\n  ");
        log.error("Client UI JavaScript error: User-Agent=" + ua + ": " + message);
        callback.onSuccess(VoidResult.INSTANCE);
    }
}

