/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gerrit.server.index.FieldType;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.IntegerRangePredicate;
import com.google.gerrit.server.index.RegexPredicate;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.index.TimestampRangePredicate;
import com.google.gerrit.server.query.AndPredicate;
import com.google.gerrit.server.query.NotPredicate;
import com.google.gerrit.server.query.OrPredicate;
import com.google.gerrit.server.query.PostFilterPredicate;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

public class QueryBuilder<V> {
    private final Schema<V> schema;
    private final org.apache.lucene.util.QueryBuilder queryBuilder;

    static Term intTerm(String name, int value) {
        BytesRefBuilder builder = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded(value, 0, builder);
        return new Term(name, builder.get());
    }

    static Term stringTerm(String name, String value) {
        BytesRefBuilder builder = new BytesRefBuilder();
        builder.append(value.getBytes(StandardCharsets.UTF_8), 0, value.length());
        return new Term(name, builder.get());
    }

    public QueryBuilder(Schema<V> schema, Analyzer analyzer) {
        this.schema = schema;
        this.queryBuilder = new org.apache.lucene.util.QueryBuilder(analyzer);
    }

    public Query toQuery(Predicate<V> p) throws QueryParseException {
        if (p instanceof AndPredicate) {
            return this.and(p);
        }
        if (p instanceof OrPredicate) {
            return this.or(p);
        }
        if (p instanceof NotPredicate) {
            return this.not(p);
        }
        if (p instanceof IndexPredicate) {
            return this.fieldQuery((IndexPredicate)p);
        }
        if (p instanceof PostFilterPredicate) {
            return new MatchAllDocsQuery();
        }
        throw new QueryParseException("cannot create query for index: " + p);
    }

    private Query or(Predicate<V> p) throws QueryParseException {
        try {
            BooleanQuery.Builder q = new BooleanQuery.Builder();
            for (int i = 0; i < p.getChildCount(); ++i) {
                q.add(this.toQuery(p.getChild(i)), BooleanClause.Occur.SHOULD);
            }
            return q.build();
        }
        catch (BooleanQuery.TooManyClauses e) {
            throw new QueryParseException("cannot create query for index: " + p, e);
        }
    }

    private Query and(Predicate<V> p) throws QueryParseException {
        try {
            BooleanQuery.Builder b = new BooleanQuery.Builder();
            ArrayList<Query> not = Lists.newArrayListWithCapacity(p.getChildCount());
            for (int i = 0; i < p.getChildCount(); ++i) {
                Predicate<V> c = p.getChild(i);
                if (c instanceof NotPredicate) {
                    Predicate<V> n = c.getChild(0);
                    if (n instanceof TimestampRangePredicate) {
                        b.add(this.notTimestamp((TimestampRangePredicate)n), BooleanClause.Occur.MUST);
                        continue;
                    }
                    not.add(this.toQuery(n));
                    continue;
                }
                b.add(this.toQuery(c), BooleanClause.Occur.MUST);
            }
            for (Query q : not) {
                b.add(q, BooleanClause.Occur.MUST_NOT);
            }
            return b.build();
        }
        catch (BooleanQuery.TooManyClauses e) {
            throw new QueryParseException("cannot create query for index: " + p, e);
        }
    }

    private Query not(Predicate<V> p) throws QueryParseException {
        Predicate<V> n = p.getChild(0);
        if (n instanceof TimestampRangePredicate) {
            return this.notTimestamp((TimestampRangePredicate)n);
        }
        return new BooleanQuery.Builder().add(new MatchAllDocsQuery(), BooleanClause.Occur.MUST).add(this.toQuery(n), BooleanClause.Occur.MUST_NOT).build();
    }

    private Query fieldQuery(IndexPredicate<V> p) throws QueryParseException {
        Preconditions.checkArgument(this.schema.hasField(p.getField()), "field not in schema v%s: %s", this.schema.getVersion(), (Object)p.getField().getName());
        FieldType<?> type = p.getType();
        if (type == FieldType.INTEGER) {
            return this.intQuery(p);
        }
        if (type == FieldType.INTEGER_RANGE) {
            return this.intRangeQuery(p);
        }
        if (type == FieldType.TIMESTAMP) {
            return this.timestampQuery(p);
        }
        if (type == FieldType.EXACT) {
            return this.exactQuery(p);
        }
        if (type == FieldType.PREFIX) {
            return this.prefixQuery(p);
        }
        if (type == FieldType.FULL_TEXT) {
            return this.fullTextQuery(p);
        }
        throw FieldType.badFieldType(type);
    }

    private Query intQuery(IndexPredicate<V> p) throws QueryParseException {
        int value;
        try {
            value = Integer.parseInt(p.getValue());
        }
        catch (NumberFormatException e) {
            throw new QueryParseException("not an integer: " + p.getValue());
        }
        return new TermQuery(QueryBuilder.intTerm(p.getField().getName(), value));
    }

    private Query intRangeQuery(IndexPredicate<V> p) throws QueryParseException {
        if (p instanceof IntegerRangePredicate) {
            int maximum;
            IntegerRangePredicate r = (IntegerRangePredicate)p;
            int minimum = r.getMinimumValue();
            if (minimum == (maximum = r.getMaximumValue())) {
                return new TermQuery(QueryBuilder.intTerm(p.getField().getName(), minimum));
            }
            return NumericRangeQuery.newIntRange(r.getField().getName(), minimum, maximum, true, true);
        }
        throw new QueryParseException("not an integer range: " + p);
    }

    private Query timestampQuery(IndexPredicate<V> p) throws QueryParseException {
        if (p instanceof TimestampRangePredicate) {
            TimestampRangePredicate r = (TimestampRangePredicate)p;
            return NumericRangeQuery.newLongRange(r.getField().getName(), r.getMinTimestamp().getTime(), r.getMaxTimestamp().getTime(), true, true);
        }
        throw new QueryParseException("not a timestamp: " + p);
    }

    private Query notTimestamp(TimestampRangePredicate<V> r) throws QueryParseException {
        if (r.getMinTimestamp().getTime() == 0L) {
            return NumericRangeQuery.newLongRange(r.getField().getName(), r.getMaxTimestamp().getTime(), null, true, true);
        }
        throw new QueryParseException("cannot negate: " + r);
    }

    private Query exactQuery(IndexPredicate<V> p) {
        if (p instanceof RegexPredicate) {
            return this.regexQuery(p);
        }
        return new TermQuery(new Term(p.getField().getName(), p.getValue()));
    }

    private Query regexQuery(IndexPredicate<V> p) {
        String re = p.getValue();
        if (re.startsWith("^")) {
            re = re.substring(1);
        }
        if (re.endsWith("$") && !re.endsWith("\\$")) {
            re = re.substring(0, re.length() - 1);
        }
        return new RegexpQuery(new Term(p.getField().getName(), re));
    }

    private Query prefixQuery(IndexPredicate<V> p) {
        return new PrefixQuery(new Term(p.getField().getName(), p.getValue()));
    }

    private Query fullTextQuery(IndexPredicate<V> p) throws QueryParseException {
        String value = p.getValue();
        if (value == null) {
            throw new QueryParseException("Full-text search over empty string not supported");
        }
        Query query = this.queryBuilder.createPhraseQuery(p.getField().getName(), value);
        if (query == null) {
            throw new QueryParseException("Cannot create full-text query with value: " + value);
        }
        return query;
    }

    public int toIndexTimeInMinutes(Date ts) {
        return (int)(ts.getTime() / 60000L);
    }
}

