/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.codahale.metrics.Metric;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.dropwizard.BucketedMetric;
import com.google.gerrit.metrics.dropwizard.DropWizardMetricMaker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class BucketedCounter
implements BucketedMetric {
    private final DropWizardMetricMaker metrics;
    private final String name;
    private final boolean isRate;
    private final Description.FieldOrdering ordering;
    protected final Field<?>[] fields;
    protected final DropWizardMetricMaker.CounterImpl total;
    private final Map<Object, DropWizardMetricMaker.CounterImpl> cells;
    private final Object lock = new Object();

    BucketedCounter(DropWizardMetricMaker metrics, String name, Description desc, Field<?> ... fields) {
        this.metrics = metrics;
        this.name = name;
        this.isRate = desc.isRate();
        this.ordering = desc.getFieldOrdering();
        this.fields = fields;
        this.total = metrics.newCounterImpl(name + "_total", this.isRate);
        this.cells = new ConcurrentHashMap<Object, DropWizardMetricMaker.CounterImpl>();
    }

    void doRemove() {
        for (DropWizardMetricMaker.CounterImpl c : this.cells.values()) {
            c.remove();
        }
        this.total.remove();
        this.metrics.remove(this.name);
    }

    DropWizardMetricMaker.CounterImpl forceCreate(Object f1, Object f2) {
        return this.forceCreate(ImmutableList.of(f1, f2));
    }

    DropWizardMetricMaker.CounterImpl forceCreate(Object f1, Object f2, Object f3) {
        return this.forceCreate(ImmutableList.of(f1, f2, f3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DropWizardMetricMaker.CounterImpl forceCreate(Object key) {
        DropWizardMetricMaker.CounterImpl c = this.cells.get(key);
        if (c != null) {
            return c;
        }
        Object object = this.lock;
        synchronized (object) {
            c = this.cells.get(key);
            if (c == null) {
                c = this.metrics.newCounterImpl(this.submetric(key), this.isRate);
                this.cells.put(key, c);
            }
            return c;
        }
    }

    private String submetric(Object key) {
        return DropWizardMetricMaker.name(this.ordering, this.name, this.name(key));
    }

    abstract String name(Object var1);

    @Override
    public Metric getTotal() {
        return this.total.metric;
    }

    @Override
    public Field<?>[] getFields() {
        return this.fields;
    }

    public Map<Object, Metric> getCells() {
        return Maps.transformValues(this.cells, c -> c.metric);
    }
}

