/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.metrics.dropwizard.DropWizardMetricMaker;
import com.google.gerrit.metrics.dropwizard.MetricJson;
import com.google.gerrit.metrics.dropwizard.MetricResource;
import com.google.gerrit.server.CurrentUser;
import com.google.inject.Inject;
import org.kohsuke.args4j.Option;

class GetMetric
implements RestReadView<MetricResource> {
    private final CurrentUser user;
    private final DropWizardMetricMaker metrics;
    @Option(name="--data-only", usage="return only values")
    boolean dataOnly;

    @Inject
    GetMetric(CurrentUser user, DropWizardMetricMaker metrics) {
        this.user = user;
        this.metrics = metrics;
    }

    public MetricJson apply(MetricResource resource) throws AuthException {
        if (!this.user.getCapabilities().canViewCaches()) {
            throw new AuthException("restricted to viewCaches");
        }
        return new MetricJson(resource.getMetric(), this.metrics.getAnnotations(resource.getName()), this.dataOnly);
    }
}

