/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.codahale.metrics.Metric;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.metrics.dropwizard.DropWizardMetricMaker;
import com.google.gerrit.metrics.dropwizard.ListMetrics;
import com.google.gerrit.metrics.dropwizard.MetricResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.ConfigResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
class MetricsCollection
implements ChildCollection<ConfigResource, MetricResource> {
    private final DynamicMap<RestView<MetricResource>> views;
    private final Provider<ListMetrics> list;
    private final Provider<CurrentUser> user;
    private final DropWizardMetricMaker metrics;

    @Inject
    MetricsCollection(DynamicMap<RestView<MetricResource>> views, Provider<ListMetrics> list, Provider<CurrentUser> user, DropWizardMetricMaker metrics) {
        this.views = views;
        this.list = list;
        this.user = user;
        this.metrics = metrics;
    }

    @Override
    public DynamicMap<RestView<MetricResource>> views() {
        return this.views;
    }

    @Override
    public RestView<ConfigResource> list() {
        return this.list.get();
    }

    @Override
    public MetricResource parse(ConfigResource parent, IdString id) throws ResourceNotFoundException, AuthException {
        if (!this.user.get().getCapabilities().canViewCaches()) {
            throw new AuthException("restricted to viewCaches");
        }
        Metric metric = this.metrics.getMetric(id.get());
        if (metric == null) {
            throw new ResourceNotFoundException(id.get());
        }
        return new MetricResource(id.get(), metric);
    }
}

