/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.pgm.init.api.InstallAllPlugins;
import com.google.gerrit.pgm.init.api.InstallPlugins;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

@Singleton
public class InitFlags {
    public boolean deleteOnFailure;
    public boolean autoStart;
    public boolean skipPlugins;
    public boolean deleteCaches;
    public boolean dev;
    public final FileBasedConfig cfg;
    public final SecureStore sec;
    public final List<String> installPlugins;
    public final boolean installAllPlugins;

    @Inject
    @VisibleForTesting
    public InitFlags(SitePaths site, SecureStore secureStore, @InstallPlugins List<String> installPlugins, @InstallAllPlugins Boolean installAllPlugins) throws IOException, ConfigInvalidException {
        this.sec = secureStore;
        this.installPlugins = installPlugins;
        this.installAllPlugins = installAllPlugins;
        this.cfg = new FileBasedConfig(site.gerrit_config.toFile(), FS.DETECTED);
        this.cfg.load();
    }
}

