/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init.api;

import com.google.common.io.ByteStreams;
import com.google.gerrit.common.Die;
import com.google.gerrit.common.FileUtil;
import com.google.gerrit.common.Version;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.SystemReader;

public class InitUtil {
    public static Die die(String why) {
        return new Die(why);
    }

    public static Die die(String why, Throwable cause) {
        return new Die(why, cause);
    }

    public static void savePublic(FileBasedConfig sec) throws IOException {
        if (FileUtil.modified(sec)) {
            sec.save();
        }
    }

    public static void mkdir(File file) {
        InitUtil.mkdir(file.toPath());
    }

    public static void mkdir(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw InitUtil.die("Cannot make directory " + path, e);
        }
    }

    public static String version() {
        return Version.getVersion();
    }

    public static String username() {
        return System.getProperty("user.name");
    }

    public static String hostname() {
        return SystemReader.getInstance().getHostname();
    }

    public static boolean isLocal(String hostname) {
        try {
            return InetAddress.getByName(hostname).isLoopbackAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static String dnOf(String name) {
        if (name != null) {
            int p = name.indexOf("://");
            if (0 < p) {
                name = name.substring(p + 3);
            }
            if (0 < (p = name.indexOf("."))) {
                name = name.substring(p + 1);
                name = "DC=" + name.replaceAll("\\.", ",DC=");
            } else {
                name = null;
            }
        }
        return name;
    }

    public static String domainOf(String name) {
        if (name != null) {
            int p = name.indexOf("://");
            if (0 < p) {
                name = name.substring(p + 3);
            }
            if (0 < (p = name.indexOf("."))) {
                name = name.substring(p + 1);
            }
        }
        return name;
    }

    public static void extract(Path dst, Class<?> sibling, String name) throws IOException {
        try (InputStream in = InitUtil.open(sibling, name);){
            if (in != null) {
                InitUtil.copy(dst, ByteStreams.toByteArray(in));
            }
        }
    }

    private static InputStream open(Class<?> sibling, String name) {
        InputStream in = sibling.getResourceAsStream(name);
        if (in == null) {
            String pkg = sibling.getName();
            int end = pkg.lastIndexOf(46);
            if (0 < end) {
                pkg = pkg.substring(0, end + 1);
                pkg = pkg.replace('.', '/');
            } else {
                pkg = "";
            }
            System.err.println("warn: Cannot read " + pkg + name);
            return null;
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Path dst, byte[] buf) throws FileNotFoundException, IOException {
        try (InputStream in2 = Files.newInputStream(dst, new OpenOption[0]);){
            if (Arrays.equals(buf, ByteStreams.toByteArray(in2))) {
                return;
            }
        }
        catch (NoSuchFileException in2) {
            // empty catch block
        }
        Files.createDirectories(dst.getParent(), new FileAttribute[0]);
        LockFile lf = new LockFile(dst.toFile());
        if (!lf.lock()) {
            throw new IOException("Cannot lock " + dst);
        }
        try {
            try (ByteArrayInputStream in = new ByteArrayInputStream(buf);
                 OutputStream out = lf.getOutputStream();){
                ByteStreams.copy(in, out);
            }
            if (!lf.commit()) {
                throw new IOException("Cannot commit " + dst);
            }
        }
        finally {
            lf.unlock();
        }
    }

    public static URI toURI(String url) throws URISyntaxException {
        URI u = new URI(url);
        if (InitUtil.isAnyAddress(u)) {
            int s = url.indexOf(42);
            url = url.substring(0, s) + InitUtil.hostname() + url.substring(s + 1);
        }
        return new URI(url);
    }

    public static boolean isAnyAddress(URI u) {
        return u.getHost() == null && (u.getAuthority().equals("*") || u.getAuthority().startsWith("*:"));
    }

    public static int portOf(URI uri) {
        int port = uri.getPort();
        if (port < 0) {
            port = "https".equals(uri.getScheme()) ? 443 : 80;
        }
        return port;
    }

    private InitUtil() {
    }
}

