/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gwtorm.client.IntKey;
import java.util.Objects;

public final class AccountSshKey {
    protected Id id;
    protected String sshPublicKey;
    protected boolean valid;

    protected AccountSshKey() {
    }

    public AccountSshKey(Id i, String pub) {
        this.id = i;
        this.sshPublicKey = pub.replace("\n", "").replace("\r", "");
        this.valid = this.id.isValid();
    }

    public Account.Id getAccount() {
        return this.id.accountId;
    }

    public Id getKey() {
        return this.id;
    }

    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    private String getPublicKeyPart(int index, String defaultValue) {
        String[] parts;
        String s = this.getSshPublicKey();
        if (s != null && s.length() > 0 && (parts = s.split(" ")).length > index) {
            return parts[index];
        }
        return defaultValue;
    }

    public String getAlgorithm() {
        return this.getPublicKeyPart(0, "none");
    }

    public String getEncodedKey() {
        return this.getPublicKeyPart(1, null);
    }

    public String getComment() {
        return this.getPublicKeyPart(2, "");
    }

    public boolean isValid() {
        return this.valid && this.id.isValid();
    }

    public void setInvalid() {
        this.valid = false;
    }

    public boolean equals(Object o) {
        if (o instanceof AccountSshKey) {
            AccountSshKey other = (AccountSshKey)o;
            return Objects.equals(this.id, other.id) && Objects.equals(this.sshPublicKey, other.sshPublicKey) && Objects.equals(this.valid, other.valid);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sshPublicKey, this.valid);
    }

    public static class Id
    extends IntKey<Account.Id> {
        private static final long serialVersionUID = 1L;
        protected Account.Id accountId;
        protected int seq;

        protected Id() {
            this.accountId = new Account.Id();
        }

        public Id(Account.Id a, int s) {
            this.accountId = a;
            this.seq = s;
        }

        @Override
        public Account.Id getParentKey() {
            return this.accountId;
        }

        @Override
        public int get() {
            return this.seq;
        }

        @Override
        protected void set(int newValue) {
            this.seq = newValue;
        }

        public boolean isValid() {
            return this.seq > 0;
        }
    }
}

