/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import java.sql.Timestamp;

public class ReviewerSet {
    private static final ReviewerSet EMPTY = new ReviewerSet(ImmutableTable.of());
    private final ImmutableTable<ReviewerStateInternal, Account.Id, Timestamp> table;
    private ImmutableSet<Account.Id> accounts;

    public static ReviewerSet fromApprovals(Iterable<PatchSetApproval> approvals) {
        PatchSetApproval first = null;
        HashBasedTable<ReviewerStateInternal, Account.Id, Timestamp> reviewers = HashBasedTable.create();
        for (PatchSetApproval psa : approvals) {
            if (first == null) {
                first = psa;
            } else {
                Preconditions.checkArgument(first.getKey().getParentKey().getParentKey().equals(psa.getKey().getParentKey().getParentKey()), "multiple change IDs: %s, %s", (Object)first.getKey(), (Object)psa.getKey());
            }
            Account.Id id = psa.getAccountId();
            reviewers.put(ReviewerStateInternal.REVIEWER, id, psa.getGranted());
            if (psa.getValue() == 0) continue;
            reviewers.remove((Object)ReviewerStateInternal.CC, id);
        }
        return new ReviewerSet(reviewers);
    }

    public static ReviewerSet fromTable(Table<ReviewerStateInternal, Account.Id, Timestamp> table) {
        return new ReviewerSet(table);
    }

    public static ReviewerSet empty() {
        return EMPTY;
    }

    private ReviewerSet(Table<ReviewerStateInternal, Account.Id, Timestamp> table) {
        this.table = ImmutableTable.copyOf(table);
    }

    public ImmutableSet<Account.Id> all() {
        if (this.accounts == null) {
            this.accounts = ImmutableSet.copyOf(this.table.columnKeySet());
        }
        return this.accounts;
    }

    public ImmutableSet<Account.Id> byState(ReviewerStateInternal state) {
        return ((ImmutableMap)this.table.row((Object)state)).keySet();
    }

    public ImmutableTable<ReviewerStateInternal, Account.Id, Timestamp> asTable() {
        return this.table;
    }

    public boolean equals(Object o) {
        return o instanceof ReviewerSet && this.table.equals(((ReviewerSet)o).table);
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.table;
    }
}

