/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class ExternalIdsUpdate {
    private final AccountCache accountCache;

    @VisibleForTesting
    public static RetryerBuilder<Void> retryerBuilder() {
        return RetryerBuilder.newBuilder().retryIfException(e -> e instanceof LockFailureException).withWaitStrategy(WaitStrategies.join(WaitStrategies.exponentialWait(2L, TimeUnit.SECONDS), WaitStrategies.randomWait(50L, TimeUnit.MILLISECONDS))).withStopStrategy(StopStrategies.stopAfterDelay(10L, TimeUnit.SECONDS));
    }

    @VisibleForTesting
    public ExternalIdsUpdate(AccountCache accountCache) {
        this.accountCache = accountCache;
    }

    public void insert(ReviewDb db, ExternalId extId) throws IOException, OrmException {
        this.insert(db, Collections.singleton(extId));
    }

    public void insert(ReviewDb db, Collection<ExternalId> extIds) throws IOException, OrmException {
        db.accountExternalIds().insert(ExternalId.toAccountExternalIds(extIds));
        this.evictAccounts(extIds);
    }

    public void upsert(ReviewDb db, ExternalId extId) throws IOException, OrmException {
        this.upsert(db, Collections.singleton(extId));
    }

    public void upsert(ReviewDb db, Collection<ExternalId> extIds) throws IOException, OrmException {
        db.accountExternalIds().upsert(ExternalId.toAccountExternalIds(extIds));
        this.evictAccounts(extIds);
    }

    public void delete(ReviewDb db, ExternalId extId) throws IOException, OrmException {
        this.delete(db, Collections.singleton(extId));
    }

    public void delete(ReviewDb db, Collection<ExternalId> extIds) throws IOException, OrmException {
        db.accountExternalIds().delete(ExternalId.toAccountExternalIds(extIds));
        this.evictAccounts(extIds);
    }

    public void delete(ReviewDb db, Account.Id accountId, ExternalId.Key extIdKey) throws IOException, OrmException {
        this.delete(db, accountId, Collections.singleton(extIdKey));
    }

    public void delete(ReviewDb db, Account.Id accountId, Collection<ExternalId.Key> extIdKeys) throws IOException, OrmException {
        db.accountExternalIds().deleteKeys(ExternalId.Key.toAccountExternalIdKeys(extIdKeys));
        this.accountCache.evict(accountId);
    }

    public void deleteAll(ReviewDb db, Account.Id accountId) throws IOException, OrmException {
        this.delete(db, ExternalId.from(db.accountExternalIds().byAccount(accountId).toList()));
    }

    public void replace(ReviewDb db, Account.Id accountId, Collection<ExternalId.Key> toDelete, Collection<ExternalId> toAdd) throws IOException, OrmException {
        ExternalIdsUpdate.checkSameAccount(toAdd, accountId);
        db.accountExternalIds().deleteKeys(ExternalId.Key.toAccountExternalIdKeys(toDelete));
        db.accountExternalIds().insert(ExternalId.toAccountExternalIds(toAdd));
        this.accountCache.evict(accountId);
    }

    public void replace(ReviewDb db, ExternalId toDelete, ExternalId toAdd) throws IOException, OrmException {
        this.replace(db, Collections.singleton(toDelete), Collections.singleton(toAdd));
    }

    public void replace(ReviewDb db, Collection<ExternalId> toDelete, Collection<ExternalId> toAdd) throws IOException, OrmException {
        Account.Id accountId = ExternalIdsUpdate.checkSameAccount(Iterables.concat(toDelete, toAdd));
        if (accountId == null) {
            return;
        }
        this.replace(db, accountId, toDelete.stream().map(e -> e.key()).collect(Collectors.toSet()), toAdd);
    }

    public static Account.Id checkSameAccount(Iterable<ExternalId> extIds) {
        return ExternalIdsUpdate.checkSameAccount(extIds, null);
    }

    public static Account.Id checkSameAccount(Iterable<ExternalId> extIds, @Nullable Account.Id accountId) {
        for (ExternalId extId : extIds) {
            if (accountId == null) {
                accountId = extId.accountId();
                continue;
            }
            Preconditions.checkState(accountId.equals(extId.accountId()), "external id %s belongs to account %s, expected account %s", (Object)extId.key().get(), (Object)extId.accountId().get(), (Object)accountId.get());
        }
        return accountId;
    }

    private void evictAccounts(Collection<ExternalId> extIds) throws IOException {
        for (Account.Id id : extIds.stream().map(ExternalId::accountId).collect(Collectors.toSet())) {
            this.accountCache.evict(id);
        }
    }

    @Singleton
    public static class User {
        private final AccountCache accountCache;

        @Inject
        public User(AccountCache accountCache) {
            this.accountCache = accountCache;
        }

        public ExternalIdsUpdate create() {
            return new ExternalIdsUpdate(this.accountCache);
        }
    }

    @Singleton
    public static class Server {
        private final AccountCache accountCache;

        @Inject
        public Server(AccountCache accountCache) {
            this.accountCache = accountCache;
        }

        public ExternalIdsUpdate create() {
            return new ExternalIdsUpdate(this.accountCache);
        }
    }
}

