/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Throwables;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.InternalAccountDirectory;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.EnumSet;

@Singleton
public class GetDetail
implements RestReadView<AccountResource> {
    private final InternalAccountDirectory directory;

    @Inject
    public GetDetail(InternalAccountDirectory directory) {
        this.directory = directory;
    }

    public AccountDetailInfo apply(AccountResource rsrc) throws OrmException {
        Account a = rsrc.getUser().getAccount();
        AccountDetailInfo info = new AccountDetailInfo(a.getId().get());
        info.registeredOn = a.getRegisteredOn();
        try {
            this.directory.fillAccountInfo(Collections.singleton(info), EnumSet.allOf(AccountDirectory.FillOptions.class));
        }
        catch (AccountDirectory.DirectoryException e) {
            Throwables.throwIfInstanceOf(e.getCause(), OrmException.class);
            throw new OrmException(e);
        }
        return info;
    }

    public static class AccountDetailInfo
    extends AccountInfo {
        public Timestamp registeredOn;

        public AccountDetailInfo(Integer id) {
            super(id);
        }
    }
}

