/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.common.SshKeyInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class GetSshKeys
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;
    private final VersionedAuthorizedKeys.Accessor authorizedKeys;

    @Inject
    GetSshKeys(Provider<CurrentUser> self, VersionedAuthorizedKeys.Accessor authorizedKeys) {
        this.self = self;
        this.authorizedKeys = authorizedKeys;
    }

    public List<SshKeyInfo> apply(AccountResource rsrc) throws AuthException, OrmException, RepositoryNotFoundException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("not allowed to get SSH keys");
        }
        return this.apply(rsrc.getUser());
    }

    public List<SshKeyInfo> apply(IdentifiedUser user) throws RepositoryNotFoundException, IOException, ConfigInvalidException {
        return Lists.transform(this.authorizedKeys.getKeys(user.getAccountId()), GetSshKeys::newSshKeyInfo);
    }

    public static SshKeyInfo newSshKeyInfo(AccountSshKey sshKey) {
        SshKeyInfo info = new SshKeyInfo();
        info.seq = sshKey.getKey().get();
        info.sshPublicKey = sshKey.getSshPublicKey();
        info.encodedKey = sshKey.getEncodedKey();
        info.algorithm = sshKey.getAlgorithm();
        info.comment = Strings.emptyToNull(sshKey.getComment());
        info.valid = sshKey.isValid();
        return info;
    }
}

