/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class PutStatus
implements RestModifyView<AccountResource, Input> {
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> dbProvider;
    private final AccountCache byIdCache;

    @Inject
    PutStatus(Provider<CurrentUser> self, Provider<ReviewDb> dbProvider, AccountCache byIdCache) {
        this.self = self;
        this.dbProvider = dbProvider;
        this.byIdCache = byIdCache;
    }

    public Response<String> apply(AccountResource rsrc, Input input) throws AuthException, ResourceNotFoundException, OrmException, IOException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("not allowed to set status");
        }
        return this.apply(rsrc.getUser(), input);
    }

    public Response<String> apply(IdentifiedUser user, Input input) throws ResourceNotFoundException, OrmException, IOException {
        if (input == null) {
            input = new Input();
        }
        final String newStatus = input.status;
        Account a = this.dbProvider.get().accounts().atomicUpdate(user.getAccountId(), new AtomicUpdate<Account>(){

            @Override
            public Account update(Account a) {
                a.setStatus(Strings.nullToEmpty(newStatus));
                return a;
            }
        });
        if (a == null) {
            throw new ResourceNotFoundException("account not found");
        }
        this.byIdCache.evict(a.getId());
        return Strings.isNullOrEmpty(a.getStatus()) ? Response.none() : Response.ok(a.getStatus());
    }

    public static class Input {
        @DefaultInput
        String status;

        public Input(String status) {
            this.status = status;
        }

        public Input() {
        }
    }
}

