/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.DeleteReviewerInput;
import com.google.gerrit.extensions.api.changes.DeleteVoteInput;
import com.google.gerrit.extensions.api.changes.ReviewerApi;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.change.DeleteReviewer;
import com.google.gerrit.server.change.DeleteVote;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.VoteResource;
import com.google.gerrit.server.change.Votes;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;

public class ReviewerApiImpl
implements ReviewerApi {
    private final ReviewerResource reviewer;
    private final Votes.List listVotes;
    private final DeleteVote deleteVote;
    private final DeleteReviewer deleteReviewer;

    @Inject
    ReviewerApiImpl(Votes.List listVotes, DeleteVote deleteVote, DeleteReviewer deleteReviewer, @Assisted ReviewerResource reviewer) {
        this.listVotes = listVotes;
        this.deleteVote = deleteVote;
        this.deleteReviewer = deleteReviewer;
        this.reviewer = reviewer;
    }

    @Override
    public Map<String, Short> votes() throws RestApiException {
        try {
            return this.listVotes.apply(this.reviewer);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot list votes", e);
        }
    }

    @Override
    public void deleteVote(String label) throws RestApiException {
        try {
            this.deleteVote.apply(new VoteResource(this.reviewer, label), null);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot delete vote", e);
        }
    }

    @Override
    public void deleteVote(DeleteVoteInput input) throws RestApiException {
        try {
            this.deleteVote.apply(new VoteResource(this.reviewer, input.label), input);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot delete vote", e);
        }
    }

    @Override
    public void remove() throws RestApiException {
        this.remove(new DeleteReviewerInput());
    }

    @Override
    public void remove(DeleteReviewerInput input) throws RestApiException {
        try {
            this.deleteReviewer.apply(this.reviewer, input);
        }
        catch (UpdateException e) {
            throw new RestApiException("Cannot remove reviewer", e);
        }
    }

    static interface Factory {
        public ReviewerApiImpl create(ReviewerResource var1);
    }
}

