/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache.h2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.server.cache.CacheBinding;
import com.google.gerrit.server.cache.MemoryCacheFactory;
import com.google.gerrit.server.cache.PersistentCacheFactory;
import com.google.gerrit.server.cache.h2.H2CacheBindingProxy;
import com.google.gerrit.server.cache.h2.H2CacheImpl;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.plugins.Plugin;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class H2CacheFactory
implements PersistentCacheFactory,
LifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(H2CacheFactory.class);
    private final MemoryCacheFactory memCacheFactory;
    private final Config config;
    private final Path cacheDir;
    private final List<H2CacheImpl<?, ?>> caches;
    private final DynamicMap<Cache<?, ?>> cacheMap;
    private final ExecutorService executor;
    private final ScheduledExecutorService cleanup;
    private final long h2CacheSize;
    private final boolean h2AutoServer;

    @Inject
    H2CacheFactory(MemoryCacheFactory memCacheFactory, @GerritServerConfig Config cfg, SitePaths site, DynamicMap<Cache<?, ?>> cacheMap) {
        this.memCacheFactory = memCacheFactory;
        this.config = cfg;
        this.cacheDir = H2CacheFactory.getCacheDir(site, cfg.getString("cache", null, "directory"));
        this.h2CacheSize = cfg.getLong("cache", null, "h2CacheSize", -1L);
        this.h2AutoServer = cfg.getBoolean("cache", null, "h2AutoServer", false);
        this.caches = new LinkedList();
        this.cacheMap = cacheMap;
        if (this.cacheDir != null) {
            this.executor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("DiskCache-Store-%d").build());
            this.cleanup = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("DiskCache-Prune-%d").setDaemon(true).build());
        } else {
            this.executor = null;
            this.cleanup = null;
        }
    }

    private static Path getCacheDir(SitePaths site, String name) {
        if (name == null) {
            return null;
        }
        Path loc = site.resolve(name);
        if (!Files.exists(loc, new LinkOption[0])) {
            try {
                Files.createDirectories(loc, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.warn("Can't create disk cache: {}", (Object)loc.toAbsolutePath());
                return null;
            }
        }
        if (!Files.isWritable(loc)) {
            log.warn("Can't write to disk cache: {}", (Object)loc.toAbsolutePath());
            return null;
        }
        log.info("Enabling disk cache {}", (Object)loc.toAbsolutePath());
        return loc;
    }

    @Override
    public void start() {
        if (this.executor != null) {
            for (H2CacheImpl<?, ?> cache : this.caches) {
                this.executor.execute(cache::start);
                ScheduledFuture<?> scheduledFuture = this.cleanup.schedule(() -> cache.prune(this.cleanup), 30L, TimeUnit.SECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.executor != null) {
            try {
                this.cleanup.shutdownNow();
                List<Runnable> pending = this.executor.shutdownNow();
                if (this.executor.awaitTermination(15L, TimeUnit.MINUTES)) {
                    if (pending != null && !pending.isEmpty()) {
                        log.info("Finishing {} disk cache updates", (Object)pending.size());
                        for (Runnable update : pending) {
                            update.run();
                        }
                    }
                } else {
                    log.info("Timeout waiting for disk cache to close");
                }
            }
            catch (InterruptedException e) {
                log.warn("Interrupted waiting for disk cache to shutdown");
            }
        }
        List<H2CacheImpl<?, ?>> list = this.caches;
        synchronized (list) {
            for (H2CacheImpl<?, ?> cache : this.caches) {
                cache.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> Cache<K, V> build(CacheBinding<K, V> in) {
        long limit = this.config.getLong("cache", in.name(), "diskLimit", in.diskLimit());
        if (this.cacheDir == null || limit <= 0L) {
            return this.memCacheFactory.build(in);
        }
        H2CacheBindingProxy<K, V> def = new H2CacheBindingProxy<K, V>(in);
        H2CacheImpl.SqlStore<K, V> store = this.newSqlStore(def.name(), def.keyType(), limit, def.expireAfterWrite(TimeUnit.SECONDS));
        H2CacheImpl<K, V> cache = new H2CacheImpl<K, V>(this.executor, store, def.keyType(), this.memCacheFactory.build(def));
        List<H2CacheImpl<?, ?>> list = this.caches;
        synchronized (list) {
            this.caches.add(cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K, V> LoadingCache<K, V> build(CacheBinding<K, V> in, CacheLoader<K, V> loader) {
        long limit = this.config.getLong("cache", in.name(), "diskLimit", in.diskLimit());
        if (this.cacheDir == null || limit <= 0L) {
            return this.memCacheFactory.build(in, loader);
        }
        H2CacheBindingProxy<K, V> def = new H2CacheBindingProxy<K, V>(in);
        H2CacheImpl.SqlStore<K, V> store = this.newSqlStore(def.name(), def.keyType(), limit, def.expireAfterWrite(TimeUnit.SECONDS));
        LoadingCache<K, V> mem = this.memCacheFactory.build(def, new H2CacheImpl.Loader<K, V>(this.executor, store, loader));
        H2CacheImpl<K, V> cache = new H2CacheImpl<K, V>(this.executor, store, def.keyType(), mem);
        List<H2CacheImpl<?, ?>> list = this.caches;
        synchronized (list) {
            this.caches.add(cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop(Plugin plugin) {
        List<H2CacheImpl<?, ?>> list = this.caches;
        synchronized (list) {
            for (Map.Entry<String, Provider<Cache<?, ?>>> entry : this.cacheMap.byPlugin(plugin.getName()).entrySet()) {
                Cache<?, ?> cache = entry.getValue().get();
                if (!this.caches.remove(cache)) continue;
                ((H2CacheImpl)cache).stop();
            }
        }
    }

    private <V, K> H2CacheImpl.SqlStore<K, V> newSqlStore(String name, TypeLiteral<K> keyType, long maxSize, Long expireAfterWrite) {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:h2:").append(this.cacheDir.resolve(name).toUri());
        if (this.h2CacheSize >= 0L) {
            url.append(";CACHE_SIZE=");
            url.append(this.h2CacheSize / 1024L);
        }
        if (this.h2AutoServer) {
            url.append(";AUTO_SERVER=TRUE");
        }
        return new H2CacheImpl.SqlStore(url.toString(), keyType, maxSize, expireAfterWrite == null ? 0L : expireAfterWrite);
    }
}

